/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.kie.remote.RemoteEntryPoint;
import org.kie.remote.RemoteFactHandle;
import org.kie.remote.TopicsConfig;
import org.kie.remote.command.DeleteCommand;
import org.kie.remote.command.InsertCommand;
import org.kie.remote.command.UpdateCommand;
import org.kie.remote.impl.AbstractRemoteEntryPoint;
import org.kie.remote.impl.RemoteFactHandleImpl;
import org.kie.remote.impl.RemoteStatefulSessionImpl;
import org.kie.remote.impl.consumer.Listener;
import org.kie.remote.impl.producer.Sender;

public class RemoteEntryPointImpl
extends AbstractRemoteEntryPoint
implements RemoteEntryPoint {
    protected final RemoteStatefulSessionImpl delegate;

    protected RemoteEntryPointImpl(Sender sender, String entryPoint, TopicsConfig topicsConfig, Listener listener) {
        super(sender, entryPoint, topicsConfig);
        this.delegate = new RemoteStatefulSessionImpl(sender, listener, topicsConfig);
    }

    protected RemoteEntryPointImpl(Sender sender, String entryPoint, TopicsConfig topicsConfig, RemoteStatefulSessionImpl delegate) {
        super(sender, entryPoint, topicsConfig);
        this.delegate = delegate;
    }

    @Override
    public <T> RemoteFactHandle<T> insert(T obj) {
        RemoteFactHandleImpl factHandle = new RemoteFactHandleImpl((Serializable)obj);
        InsertCommand command = new InsertCommand(factHandle, this.entryPoint);
        this.sender.sendCommand(command, this.topicsConfig.getEventsTopicName());
        return factHandle;
    }

    @Override
    public <T> void delete(RemoteFactHandle<T> handle) {
        DeleteCommand command = new DeleteCommand(handle, this.entryPoint);
        this.sender.sendCommand(command, this.topicsConfig.getEventsTopicName());
    }

    @Override
    public <T> void update(RemoteFactHandle<T> handle, T object) {
        UpdateCommand command = new UpdateCommand(handle, object, this.entryPoint);
        this.sender.sendCommand(command, this.topicsConfig.getEventsTopicName());
    }

    @Override
    protected Map<String, CompletableFuture<Object>> getRequestsStore() {
        return this.delegate.getRequestsStore();
    }
}

