/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.remote.DroolsExecutor;

public class DroolsExecutorTest {
    private static final int ITERATIONS = 3;
    private static final String[] TEST_SIDE_EFFECTS = new String[]{"effect1", "effect2"};

    @Test
    public void testGetmain() {
        DroolsExecutor mainExecutor = DroolsExecutorTest.getMainExecutor();
        Assertions.assertThat((Object)mainExecutor).isInstanceOf(DroolsExecutor.Leader.class);
    }

    @Test
    public void testGetSecondary() {
        DroolsExecutor secondary = DroolsExecutorTest.getSecondaryExecutor();
        Assertions.assertThat((Object)secondary).isInstanceOf(DroolsExecutor.Secondary.class);
    }

    @Test
    public void testExecuteRunnableOnMain() {
        DroolsExecutor main = DroolsExecutorTest.getMainExecutor();
        for (int i = 0; i < 3; ++i) {
            main.execute((Runnable)new DummyRunnable());
        }
        Queue results = main.getAndReset();
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((int)results.size()).isEqualTo(3);
        Assertions.assertThat((Iterable)results).containsOnly((Object[])new Serializable[]{DroolsExecutor.EmptyResult.INSTANCE});
        Assertions.assertThat((Iterable)main.getAndReset()).isEmpty();
    }

    @Test
    public void testExecuteSupplierOnMain() {
        DroolsExecutor main = DroolsExecutorTest.getMainExecutor();
        String testString = "test string";
        String resultString = (String)main.execute(() -> "test string");
        Assertions.assertThat((String)resultString).isEqualTo("test string");
        Queue results = main.getAndReset();
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThat(results.poll()).isEqualTo((Object)"test string");
        Assertions.assertThat((Iterable)main.getAndReset()).isEmpty();
    }

    @Test
    public void testExecuteOnSecondary() {
        DroolsExecutor secondary = DroolsExecutorTest.getSecondaryExecutor();
        ArrayDeque<String> sideEffects = new ArrayDeque<String>(Arrays.asList(TEST_SIDE_EFFECTS));
        secondary.appendSideEffects(sideEffects);
        secondary.execute((Runnable)new DummyRunnable());
        ((AbstractStringAssert)Assertions.assertThat((String)((String)secondary.execute(() -> "test"))).isNotNull()).isEqualTo(TEST_SIDE_EFFECTS[1]);
        Assertions.assertThat((String)((String)secondary.execute(() -> "test"))).isNull();
    }

    private static DroolsExecutor getMainExecutor() {
        DroolsExecutor.setAsLeader();
        return DroolsExecutor.getInstance();
    }

    private static DroolsExecutor getSecondaryExecutor() {
        DroolsExecutor.setAsReplica();
        return DroolsExecutor.getInstance();
    }

    private class DummyRunnable
    implements Runnable {
        private DummyRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

