/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializationUtil {
    private SerializationUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(Object obj) {
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(obj);
            }
            byte[] byArray = b.toByteArray();
            return byArray;
        }
        catch (IOException io) {
            throw new IllegalArgumentException(io.getMessage(), io);
        }
    }

    public static <T> T deserialize(byte[] bytez) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytez));
            return (T)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

