/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializationUtil {
    private SerializationUtil() {
    }

    public static byte[] serialize(Object obj) {
        byte[] byArray;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(obj);
            }
            byArray = b.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    b.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException io) {
                throw new IllegalArgumentException(io.getMessage(), io);
            }
        }
        b.close();
        return byArray;
    }

    public static <T> T deserialize(byte[] bytez) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytez));
            return (T)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

