/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote;

import java.util.Optional;

public class TopicsConfig {
    private String eventsTopicName;
    private String kieSessionInfosTopicName;

    public static TopicsConfig getDefaultTopicsConfig() {
        return TopicsConfig.anTopicsConfig().withKieSessionInfosTopicName(Optional.ofNullable(System.getenv("kiesessioninfos")).orElse("kiesessioninfos")).withEventsTopicName(Optional.ofNullable(System.getenv("events")).orElse("events")).build();
    }

    private TopicsConfig() {
    }

    public static TopicsConfig anTopicsConfig() {
        return new TopicsConfig();
    }

    public TopicsConfig withEventsTopicName(String eventsTopicName) {
        this.eventsTopicName = eventsTopicName;
        return this;
    }

    public TopicsConfig withKieSessionInfosTopicName(String kieSessionInfosTopicName) {
        this.kieSessionInfosTopicName = kieSessionInfosTopicName;
        return this;
    }

    public TopicsConfig build() {
        TopicsConfig topicsConfig = new TopicsConfig();
        topicsConfig.eventsTopicName = this.eventsTopicName;
        topicsConfig.kieSessionInfosTopicName = this.kieSessionInfosTopicName;
        return topicsConfig;
    }

    public String getEventsTopicName() {
        return this.eventsTopicName;
    }

    public String getKieSessionInfosTopicName() {
        return this.kieSessionInfosTopicName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TopicsConfig{");
        sb.append(", eventsTopicName='").append(this.eventsTopicName).append('\'');
        sb.append(", kieSessionInfosTopicName='").append(this.kieSessionInfosTopicName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

