/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.osgi.example;

import java.util.HashMap;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationProcessExample {
    private static final Logger logger = LoggerFactory.getLogger(EvaluationProcessExample.class);
    private StatefulKnowledgeSession ksession;

    public void init() throws Exception {
        logger.info("Loading EvaluationProcess.bpmn2");
        KnowledgeBase kbase = this.createKnowledgeBase();
        this.ksession = this.createKnowledgeSession(kbase);
        logger.info("Register tasks");
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        logger.info("Start process EvaluationProcess.bpmn2");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        logger.info("Stated completed");
    }

    public void destroy() {
        this.ksession.destroy();
    }

    private KnowledgeBase createKnowledgeBase() {
        logger.info("Loading process EvaluationProcess.bpmn2");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"bpmn/EvaluationProcess.bpmn2"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }

    private StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        this.ksession = kbase.newStatefulKnowledgeSession();
        return this.ksession;
    }
}

