/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart;

import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.drools.eclipse.flow.common.editor.editpart.ElementCellEditorLocator;
import org.drools.eclipse.flow.common.editor.editpart.figure.ElementFigure;
import org.drools.eclipse.flow.common.editor.policy.ElementDirectEditManager;
import org.drools.eclipse.flow.common.editor.policy.ElementDirectEditPolicy;
import org.drools.eclipse.flow.common.editor.policy.ElementEditPolicy;
import org.drools.eclipse.flow.common.editor.policy.ElementNodeEditPolicy;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.TextCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
ModelListener {
    private DirectEditManager manager;
    private IJavaProject project;

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ElementNodeEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ElementEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ElementDirectEditPolicy());
    }

    public ElementWrapper getElementWrapper() {
        return (ElementWrapper)this.getModel();
    }

    protected List<ElementConnection> getModelSourceConnections() {
        return this.getElementWrapper().getOutgoingConnections();
    }

    protected List<ElementConnection> getModelTargetConnections() {
        return this.getElementWrapper().getIncomingConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    protected void refreshVisuals() {
        ElementWrapper element = this.getElementWrapper();
        ElementFigure figure = (ElementFigure)this.getFigure();
        figure.setText(element.getName());
        if (element.getConstraint().width == -1) {
            element.getConstraint().width = figure.getBounds().width;
        }
        if (element.getConstraint().height == -1) {
            element.getConstraint().height = figure.getBounds().height;
        }
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)figure, (Object)element.getConstraint());
    }

    @Override
    public void modelChanged(ModelEvent event) {
        if (event.getChange() == 1) {
            this.refreshTargetConnections();
        } else if (event.getChange() == 2) {
            this.refreshSourceConnections();
        } else if (event.getChange() == 4) {
            this.refreshVisuals();
        } else if (event.getChange() == 3) {
            this.refreshVisuals();
        }
    }

    public void activate() {
        super.activate();
        ((ElementWrapper)this.getModel()).addListener(this);
    }

    public void deactivate() {
        ((ElementWrapper)this.getModel()).removeListener(this);
        super.deactivate();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
        if (request.getType() == "open") {
            this.doubleClicked();
        } else {
            super.performRequest(request);
        }
    }

    protected void doubleClicked() {
    }

    private void performDirectEdit() {
        Label label = ((ElementFigure)this.getFigure()).getLabel();
        if (label == null) {
            return;
        }
        if (this.manager == null) {
            this.manager = new ElementDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new ElementCellEditorLocator(label));
        }
        this.manager.show();
    }

    public void setProject(IJavaProject project) {
        this.project = project;
    }

    public IJavaProject getProject() {
        return this.project;
    }
}

