/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewBrlFileWizardPage
extends WizardNewFileCreationPage {
    private static final String BRL_EXTENSION = ".brl";
    private IWorkbench workbench;

    public NewBrlFileWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        super("createGuidedRuleFilePage", selection);
        this.setTitle("RuleBuilder Editor File");
        this.setDescription("This wizard creates a new file with *.brl extension that can be opened by a multi-page editor.");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setPageComplete(true);
    }

    public boolean finish() {
        IFile newFile;
        String fileName = this.getFileName();
        if (!fileName.endsWith(BRL_EXTENSION)) {
            this.setFileName(String.valueOf(fileName) + BRL_EXTENSION);
        }
        if ((newFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DroolsEclipsePlugin.log(e);
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        String contents = "";
        return new ByteArrayInputStream(contents.getBytes());
    }
}

