/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.util;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathAccessRule;
import org.eclipse.jdt.internal.core.ClasspathEntry;

public class DroolsClasspathContainer
implements IClasspathContainer {
    IClasspathEntry[] droolsLibraryEntries;
    IPath path;
    IJavaProject javaProject = null;

    public DroolsClasspathContainer(IJavaProject project, IPath path) {
        this.javaProject = project;
        this.path = path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.droolsLibraryEntries == null) {
            this.droolsLibraryEntries = this.createDroolsLibraryEntries(this.javaProject);
        }
        return this.droolsLibraryEntries;
    }

    public String getDescription() {
        return "Drools Library";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    private IClasspathEntry[] createDroolsLibraryEntries(IJavaProject project) {
        int internalAPI = DroolsEclipsePlugin.getDefault().getPluginPreferences().getInt("Drools.InternalAPI");
        String[] jarNames = this.getJarNames(project);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        if (jarNames != null) {
            int i = 0;
            while (i < jarNames.length) {
                Path path = new Path(jarNames[i]);
                if (internalAPI != 0) {
                    if (jarNames[i].contains("drools-api")) {
                        list.add(JavaCore.newLibraryEntry((IPath)path, (IPath)path, null));
                    } else {
                        IAccessRule[] accessRules = new IAccessRule[]{new ClasspathAccessRule((IPath)new Path("**"), internalAPI)};
                        list.add(JavaCore.newLibraryEntry((IPath)path, (IPath)path, null, (IAccessRule[])accessRules, (IClasspathAttribute[])ClasspathEntry.NO_EXTRA_ATTRIBUTES, (boolean)false));
                    }
                }
                ++i;
            }
        }
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    private String[] getJarNames(IJavaProject project) {
        return DroolsRuntimeManager.getDroolsRuntimeJars(project.getProject());
    }
}

