/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DefaultDroolsRuntimeRecognizer;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeRecognizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class DroolsRuntimeManager {
    private static final String DROOLS_RUNTIME_RECOGNIZER = "org.drools.eclipse.runtimeRecognizer";

    public static void createDefaultRuntime(String location) {
        ArrayList<String> jars = new ArrayList<String>();
        String s = DroolsRuntimeManager.getDroolsLocation();
        File file = new Path(s).toFile();
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() && files[i].getName().equals("lib")) {
                File[] jarFiles = files[i].listFiles();
                int j = 0;
                while (j < jarFiles.length) {
                    if (jarFiles[j].getPath().endsWith(".jar")) {
                        jars.add(jarFiles[j].getAbsolutePath());
                    }
                    ++j;
                }
            }
            ++i;
        }
        String pluginRootString = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "plugins/";
        File pluginRoot = new Path(pluginRootString).toFile();
        files = pluginRoot.listFiles();
        boolean found = false;
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2].getAbsolutePath().indexOf("org.eclipse.jdt.core_3.7") > -1) {
                jars.add(files[i2].getAbsolutePath());
                found = true;
                break;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < files.length) {
            if (files[i2].getAbsolutePath().indexOf("org.eclipse.jdt.core_3.6") > -1) {
                jars.add(files[i2].getAbsolutePath());
                found = true;
                break;
            }
            ++i2;
        }
        if (!found) {
            i2 = 0;
            while (i2 < files.length) {
                if (files[i2].getAbsolutePath().indexOf("org.eclipse.jdt.core_3.5") > -1) {
                    jars.add(files[i2].getAbsolutePath());
                    found = true;
                    break;
                }
                ++i2;
            }
        }
        if (!found) {
            i2 = 0;
            while (i2 < files.length) {
                if (files[i2].getAbsolutePath().indexOf("org.eclipse.jdt.core_3.4") > -1) {
                    jars.add(files[i2].getAbsolutePath());
                    break;
                }
                ++i2;
            }
        }
        if (!location.endsWith(File.separator)) {
            location = String.valueOf(location) + File.separator;
        }
        for (String jar : jars) {
            try {
                File jarFile = new File(jar);
                FileChannel inChannel = new FileInputStream(jarFile).getChannel();
                FileChannel outChannel = new FileOutputStream(new File(String.valueOf(location) + jarFile.getName())).getChannel();
                try {
                    inChannel.transferTo(0L, inChannel.size(), outChannel);
                }
                finally {
                    if (inChannel != null) {
                        inChannel.close();
                    }
                    if (outChannel != null) {
                        outChannel.close();
                    }
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
            }
        }
    }

    private static String getDroolsLocation() {
        try {
            return FileLocator.toFileURL((URL)Platform.getBundle((String)"org.drools.eclipse").getEntry("/")).getFile().toString();
        }
        catch (IOException e) {
            DroolsEclipsePlugin.log(e);
            return null;
        }
    }

    private static String generateString(DroolsRuntime[] droolsRuntimes) {
        String result = "";
        DroolsRuntime[] droolsRuntimeArray = droolsRuntimes;
        int n = droolsRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime runtime = droolsRuntimeArray[n2];
            result = String.valueOf(result) + runtime.getName() + "#" + runtime.getPath() + "#" + runtime.isDefault() + "# ";
            if (runtime.getJars() != null) {
                String[] stringArray = runtime.getJars();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jar = stringArray[n4];
                    result = String.valueOf(result) + jar + ";";
                    ++n4;
                }
            }
            result = String.valueOf(result) + "###";
            ++n2;
        }
        return result;
    }

    private static DroolsRuntime[] generateRuntimes(String s) {
        ArrayList<DroolsRuntime> result = new ArrayList<DroolsRuntime>();
        if (s != null && !"".equals(s)) {
            String[] runtimeStrings;
            String[] stringArray = runtimeStrings = s.split("###");
            int n = runtimeStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String runtimeString = stringArray[n2];
                String[] properties = runtimeString.split("#");
                DroolsRuntime runtime = new DroolsRuntime();
                runtime.setName(properties[0]);
                runtime.setPath(properties[1]);
                runtime.setDefault("true".equals(properties[2]));
                if (properties.length > 3) {
                    String[] jars;
                    ArrayList<String> list = new ArrayList<String>();
                    String[] stringArray2 = jars = properties[3].split(";");
                    int n3 = jars.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String jar = stringArray2[n4];
                        if ((jar = jar.trim()).length() > 0) {
                            list.add(jar);
                        }
                        ++n4;
                    }
                    runtime.setJars(list.toArray(new String[list.size()]));
                }
                result.add(runtime);
                ++n2;
            }
        }
        return result.toArray(new DroolsRuntime[result.size()]);
    }

    public static DroolsRuntime[] getDroolsRuntimes() {
        String runtimesString = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Runtimes");
        if (runtimesString != null) {
            return DroolsRuntimeManager.generateRuntimes(runtimesString);
        }
        return new DroolsRuntime[0];
    }

    public static void setDroolsRuntimes(DroolsRuntime[] runtimes) {
        DroolsEclipsePlugin.getDefault().getPreferenceStore().setValue("Drools.Runtimes", DroolsRuntimeManager.generateString(runtimes));
    }

    public static DroolsRuntime getDroolsRuntime(String name) {
        DroolsRuntime[] runtimes;
        DroolsRuntime[] droolsRuntimeArray = runtimes = DroolsRuntimeManager.getDroolsRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime runtime = droolsRuntimeArray[n2];
            if (runtime.getName().equals(name)) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    public static DroolsRuntime getDefaultDroolsRuntime() {
        DroolsRuntime[] runtimes;
        DroolsRuntime[] droolsRuntimeArray = runtimes = DroolsRuntimeManager.getDroolsRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            DroolsRuntime runtime = droolsRuntimeArray[n2];
            if (runtime.isDefault()) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    public static String getDroolsRuntime(IProject project) {
        try {
            BufferedReader reader;
            String location;
            IFile file = project.getFile(".settings/.drools.runtime");
            if (file.exists() && (location = (reader = new BufferedReader(new InputStreamReader(file.getContents()))).readLine()).startsWith("<runtime>") && location.endsWith("</runtime>")) {
                return location.substring(9, location.length() - 10);
            }
        }
        catch (Exception e) {
            DroolsEclipsePlugin.log(e);
        }
        return null;
    }

    public static String[] getDroolsRuntimeJars(IProject project) {
        String runtimeName = DroolsRuntimeManager.getDroolsRuntime(project);
        DroolsRuntime runtime = null;
        runtime = runtimeName == null ? DroolsRuntimeManager.getDefaultDroolsRuntime() : DroolsRuntimeManager.getDroolsRuntime(runtimeName);
        if (runtime == null) {
            return null;
        }
        if (runtime.getJars() == null || runtime.getJars().length == 0) {
            DroolsRuntimeManager.recognizeJars(runtime);
        }
        return runtime.getJars();
    }

    public static void recognizeJars(DroolsRuntime runtime) {
        String path = runtime.getPath();
        if (path != null) {
            try {
                IConfigurationElement[] config;
                IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(DROOLS_RUNTIME_RECOGNIZER);
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] jars;
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof DroolsRuntimeRecognizer && (jars = ((DroolsRuntimeRecognizer)o).recognizeJars(path)) != null && jars.length > 0) {
                        runtime.setJars(jars);
                        return;
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
            runtime.setJars(new DefaultDroolsRuntimeRecognizer().recognizeJars(path));
        }
    }
}

