/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.core.ElementContainer;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.drools.eclipse.flow.common.view.property.ListPropertyDescriptor;
import org.drools.eclipse.flow.ruleflow.view.property.exceptionHandler.ExceptionHandlersPropertyDescriptor;
import org.drools.eclipse.flow.ruleflow.view.property.swimlane.SwimlanesCellEditor;
import org.drools.eclipse.flow.ruleflow.view.property.variable.VariableListCellEditor;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jbpm.process.core.Process;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.context.swimlane.SwimlaneContext;
import org.jbpm.process.core.context.variable.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessWrapper
implements ElementContainer,
IPropertySource,
Serializable {
    private static final long serialVersionUID = 510L;
    public static final int CHANGE_ELEMENTS = 1;
    public static final int CHANGE_ROUTER_LAYOUT = 2;
    public static final Integer ROUTER_LAYOUT_MANUAL = new Integer(0);
    public static final Integer ROUTER_LAYOUT_MANHATTAN = new Integer(1);
    public static final Integer ROUTER_LAYOUT_SHORTEST_PATH = new Integer(2);
    public static final String NAME = "name";
    public static final String VERSION = "version";
    public static final String ID = "id";
    public static final String PACKAGE_NAME = "packageName";
    public static final String ROUTER_LAYOUT = "routerLayout";
    public static final String VARIABLES = "variables";
    public static final String SWIMLANES = "swimlanes";
    public static final String EXCEPTION_HANDLERS = "exceptionHandlers";
    private Process process;
    private Map<String, ElementWrapper> elements = new HashMap<String, ElementWrapper>();
    private transient List<ModelListener> listeners = new ArrayList<ModelListener>();
    protected IPropertyDescriptor[] descriptors;

    public ProcessWrapper() {
        this.process = (Process)this.createProcess();
    }

    protected abstract org.drools.definition.process.Process createProcess();

    public org.drools.definition.process.Process getProcess() {
        return this.process;
    }

    public void localSetProcess(org.drools.definition.process.Process process) {
        this.process = (Process)process;
    }

    public String getName() {
        return this.process.getName() == null ? "" : this.process.getName();
    }

    public void setName(String name) {
        this.process.setName(name);
    }

    public String getVersion() {
        return this.process.getVersion() == null ? "" : this.process.getVersion();
    }

    public void setVersion(String version) {
        this.process.setVersion(version);
    }

    public String getId() {
        return this.process.getId();
    }

    public void setId(String id) {
        this.process.setId(id);
    }

    public String getPackageName() {
        return this.process.getPackageName() == null ? "" : this.process.getPackageName();
    }

    public void setPackageName(String packageName) {
        this.process.setPackageName(packageName);
    }

    public Integer getRouterLayout() {
        Integer routerLayout = (Integer)this.process.getMetaData().get(ROUTER_LAYOUT);
        if (routerLayout == null) {
            return ROUTER_LAYOUT_MANUAL;
        }
        return routerLayout;
    }

    public void setRouterLayout(Integer routerLayout) {
        this.process.setMetaData(ROUTER_LAYOUT, (Object)routerLayout);
        this.notifyListeners(2);
    }

    @Override
    public List<ElementWrapper> getElements() {
        return Collections.unmodifiableList(new ArrayList<ElementWrapper>(this.elements.values()));
    }

    public ElementWrapper getElement(String id) {
        return this.elements.get(id);
    }

    @Override
    public void addElement(ElementWrapper element) {
        this.internalAddElement(element);
        this.localAddElement(element);
        this.notifyListeners(1);
    }

    @Override
    public void localAddElement(ElementWrapper element) {
        this.elements.put(element.getId(), element);
    }

    protected abstract void internalAddElement(ElementWrapper var1);

    @Override
    public void removeElement(ElementWrapper element) {
        this.elements.remove(element.getId());
        this.notifyListeners(1);
        this.internalRemoveElement(element);
    }

    protected abstract void internalRemoveElement(ElementWrapper var1);

    @Override
    public ProcessWrapper getProcessWrapper() {
        return this;
    }

    public void addListener(ModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(int change) {
        ModelEvent event = new ModelEvent(change);
        for (ModelListener listener : this.listeners) {
            listener.modelChanged(event);
        }
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.listeners = new ArrayList<ModelListener>();
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.initPropertyDescriptors();
        }
        return this.descriptors;
    }

    public void initPropertyDescriptors() {
        this.descriptors = this.isFullProperties() ? new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)NAME, "Name"), new TextPropertyDescriptor((Object)VERSION, "Version"), new TextPropertyDescriptor((Object)ID, "Id"), new TextPropertyDescriptor((Object)PACKAGE_NAME, "Package"), new ComboBoxPropertyDescriptor((Object)ROUTER_LAYOUT, "Connection Layout", new String[]{"Manual", "Manhattan", "Shortest Path"}), new ListPropertyDescriptor(VARIABLES, "Variables", VariableListCellEditor.class), new ListPropertyDescriptor(SWIMLANES, "Swimlanes", SwimlanesCellEditor.class), new ExceptionHandlersPropertyDescriptor((Object)EXCEPTION_HANDLERS, "Exception Handlers", (org.drools.definition.process.Process)this.process)} : new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)NAME, "Name"), new TextPropertyDescriptor((Object)VERSION, "Version"), new TextPropertyDescriptor((Object)ID, "Id"), new TextPropertyDescriptor((Object)PACKAGE_NAME, "Package"), new ListPropertyDescriptor(VARIABLES, "Variables", VariableListCellEditor.class), new ListPropertyDescriptor(SWIMLANES, "Swimlanes", SwimlanesCellEditor.class)};
    }

    public boolean isFullProperties() {
        return true;
    }

    public Object getPropertyValue(Object id) {
        if (NAME.equals(id)) {
            return this.getName();
        }
        if (VERSION.equals(id)) {
            return this.getVersion();
        }
        if (ID.equals(id)) {
            return String.valueOf(this.getId());
        }
        if (PACKAGE_NAME.equals(id)) {
            return this.getPackageName();
        }
        if (ROUTER_LAYOUT.equals(id)) {
            return this.getRouterLayout();
        }
        if (VARIABLES.equals(id)) {
            return ((VariableScope)this.process.getDefaultContext("VariableScope")).getVariables();
        }
        if (SWIMLANES.equals(id)) {
            return ((SwimlaneContext)this.process.getDefaultContext("SwimlaneScope")).getSwimlanes();
        }
        if (EXCEPTION_HANDLERS.equals(id)) {
            return ((ExceptionScope)this.process.getDefaultContext("ExceptionScope")).getExceptionHandlers();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
        if (NAME.equals(id)) {
            this.setName("");
        }
        if (VERSION.equals(id)) {
            this.setVersion("");
        }
        if (ID.equals(id)) {
            this.setId("");
        }
        if (PACKAGE_NAME.equals(id)) {
            this.setPackageName("");
        }
        if (ROUTER_LAYOUT.equals(id)) {
            this.setRouterLayout(null);
        }
        if (VARIABLES.equals(id)) {
            ((VariableScope)this.process.getDefaultContext("VariableScope")).setVariables(new ArrayList());
        }
        if (SWIMLANES.equals(id)) {
            ((SwimlaneContext)this.process.getDefaultContext("SwimlaneScope")).setSwimlanes(new ArrayList());
        }
        if (EXCEPTION_HANDLERS.equals(id)) {
            ((ExceptionScope)this.process.getDefaultContext("ExceptionScope")).setExceptionHandlers(new HashMap());
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (NAME.equals(id)) {
            this.setName((String)value);
        } else if (VERSION.equals(id)) {
            this.setVersion((String)value);
        } else if (ID.equals(id)) {
            this.setId((String)value);
        } else if (PACKAGE_NAME.equals(id)) {
            this.setPackageName((String)value);
        } else if (ROUTER_LAYOUT.equals(id)) {
            this.setRouterLayout((Integer)value);
        } else if (VARIABLES.equals(id)) {
            ((VariableScope)this.process.getDefaultContext("VariableScope")).setVariables((List)value);
        } else if (SWIMLANES.equals(id)) {
            ((SwimlaneContext)this.process.getDefaultContext("SwimlaneScope")).setSwimlanes((Collection)((List)value));
        } else if (EXCEPTION_HANDLERS.equals(id)) {
            ((ExceptionScope)this.process.getDefaultContext("ExceptionScope")).setExceptionHandlers((Map)value);
        }
    }

    @Override
    public boolean canAddElement(ElementWrapper element) {
        return true;
    }
}

