/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class RuleAttributeWidget
extends Widget {
    public RuleAttributeWidget(FormToolkit toolkit, Composite parent, RuleModeller modeller) {
        super(parent, toolkit, modeller, 0);
        GridLayout l = new GridLayout();
        l.numColumns = 3;
        parent.setLayout((Layout)l);
        this.create();
    }

    private void create() {
        RuleAttribute[] attrs = this.modeller.getModel().attributes;
        int i = 0;
        while (i < attrs.length) {
            RuleAttribute at = attrs[i];
            this.addAttribute(at);
            ++i;
        }
        this.toolkit.paintBordersFor(this.parent);
    }

    private void addAttribute(RuleAttribute at) {
        this.toolkit.createLabel(this.parent, at.attributeName);
        if (at.attributeName.equals("no-loop")) {
            this.toolkit.createLabel(this.parent, "");
        } else if (at.attributeName.equals("enabled") || at.attributeName.equals("auto-focus") || at.attributeName.equals("lock-on-active")) {
            this.createCheckbox(at);
        } else {
            this.createText(at);
        }
        this.addDeleteLink(at);
    }

    private void createText(final RuleAttribute at) {
        final Text box = this.toolkit.createText(this.parent, "");
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        box.setLayoutData((Object)gd);
        box.setText(at.value);
        box.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                at.value = box.getText();
                RuleAttributeWidget.this.modeller.setDirty(true);
            }
        });
        if ((at.attributeName.equals("date-effective") || at.attributeName.equals("date-expires")) && (at.value == null || "".equals(at.value.trim()))) {
            box.setText("dd-MMM-yyyy");
        }
    }

    private void createCheckbox(final RuleAttribute at) {
        final Button checkbox = this.toolkit.createButton(this.parent, "", 32);
        if (at.value == null) {
            checkbox.setSelection(true);
            at.value = "true";
        } else {
            checkbox.setSelection(at.value.equals("true"));
        }
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                at.value = checkbox.getSelection() ? "true" : "false";
                RuleAttributeWidget.this.modeller.setDirty(true);
            }
        });
    }

    private void addDeleteLink(final RuleAttribute at) {
        ImageHyperlink delLink = this.addImage(this.parent, "icons/delete_item_small.gif");
        delLink.setToolTipText("Remove this fieldconstraint");
        delLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this rule option?");
                dialog.setText("Remove this rule option?");
                if (dialog.open() == 64) {
                    RuleAttribute[] attrs = RuleAttributeWidget.this.modeller.getModel().attributes;
                    int i = 0;
                    while (i < attrs.length) {
                        if (attrs[i] == at) {
                            RuleAttributeWidget.this.modeller.getModel().removeAttribute(i);
                            RuleAttributeWidget.this.modeller.setDirty(true);
                            RuleAttributeWidget.this.modeller.reloadOptions();
                        }
                        ++i;
                    }
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    public static List getAttributeList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("...");
        list.add("salience");
        list.add("enabled");
        list.add("date-effective");
        list.add("date-expires");
        list.add("no-loop");
        list.add("agenda-group");
        list.add("activation-group");
        list.add("duration");
        list.add("auto-focus");
        list.add("lock-on-active");
        list.add("ruleflow-group");
        list.add("dialect");
        return list;
    }
}

