/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.editor.editpart;

import java.net.URL;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.figure.AbstractElementFigure;
import org.drools.eclipse.flow.ruleflow.skin.SkinManager;
import org.drools.eclipse.flow.ruleflow.skin.SkinProvider;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class MilestoneEditPart
extends ElementEditPart {
    private String SKIN = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Flow.Skin");
    private static final Color color = new Color((Device)Display.getCurrent(), 255, 250, 205);

    protected IFigure createFigure() {
        SkinProvider skinProvider = SkinManager.getInstance().getSkinProvider(this.SKIN);
        IFigure result = skinProvider.createMilestoneFigure();
        Rectangle constraint = this.getElementWrapper().getConstraint();
        if (constraint.width == -1) {
            constraint.width = result.getSize().width;
        }
        if (constraint.height == -1) {
            constraint.height = result.getSize().height;
        }
        this.getElementWrapper().setConstraint(constraint);
        return result;
    }

    public static class MilestoneFigure
    extends AbstractElementFigure {
        private static final Image ICON = ImageDescriptor.createFromURL((URL)DroolsEclipsePlugin.getDefault().getBundle().getEntry("icons/question.gif")).createImage();
        private RoundedRectangle rectangle;

        protected void customizeFigure() {
            this.rectangle = new RoundedRectangle();
            this.rectangle.setCornerDimensions(new Dimension(25, 25));
            this.add((IFigure)this.rectangle, 0);
            this.rectangle.setBackgroundColor(color);
            this.rectangle.setBounds(this.getBounds());
            this.setSelected(false);
            this.setIcon(ICON);
        }

        public void setBounds(Rectangle rectangle) {
            super.setBounds(rectangle);
            this.rectangle.setBounds(rectangle);
        }

        public void setSelected(boolean b) {
            super.setSelected(b);
            this.rectangle.setLineWidth(b ? 3 : 1);
            this.repaint();
        }
    }
}

