/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.GenericModelEditor;
import org.drools.eclipse.flow.common.editor.core.DefaultElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ProcessWrapper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.kie.definition.process.Connection;
import org.kie.definition.process.Node;
import org.kie.definition.process.WorkflowProcess;

public class VerticalAutoLayoutAction
extends ActionDelegate
implements IEditorActionDelegate {
    private IEditorPart editor;

    public void run(IAction action) {
        this.execute();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor;
    }

    private void execute() {
        this.editor.doSave(null);
        HashMap<Long, org.eclipse.draw2d.graph.Node> mapping = new HashMap<Long, org.eclipse.draw2d.graph.Node>();
        DirectedGraph graph = this.createDirectedGraph(mapping);
        DirectedGraphLayout layout = new DirectedGraphLayout();
        layout.visit(graph);
        for (Map.Entry entry : mapping.entrySet()) {
            org.eclipse.draw2d.graph.Node node = (org.eclipse.draw2d.graph.Node)entry.getValue();
            DefaultElementWrapper elementWrapper = (DefaultElementWrapper)((ProcessWrapper)((GenericModelEditor)this.editor).getModel()).getElement("" + entry.getKey());
            elementWrapper.setConstraint(new Rectangle(node.x, node.y, node.width, node.height));
        }
        this.editor.doSave(null);
    }

    protected DirectedGraph createDirectedGraph(Map<Long, org.eclipse.draw2d.graph.Node> mapping) {
        Node processNode;
        DirectedGraph graph = new DirectedGraph();
        WorkflowProcess process = (WorkflowProcess)((ProcessWrapper)((GenericModelEditor)this.editor).getModel()).getProcess();
        Node[] nodeArray = process.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            processNode = nodeArray[n2];
            org.eclipse.draw2d.graph.Node node = new org.eclipse.draw2d.graph.Node();
            Integer width = (Integer)processNode.getMetaData().get("width");
            Integer height = (Integer)processNode.getMetaData().get("height");
            if (width == null || width <= 0) {
                width = 80;
            }
            if (height == null || height <= 0) {
                height = 40;
            }
            node.setSize(new Dimension(width.intValue(), height.intValue()));
            graph.nodes.add((Object)node);
            mapping.put(processNode.getId(), node);
            ++n2;
        }
        nodeArray = process.getNodes();
        n = nodeArray.length;
        n2 = 0;
        while (n2 < n) {
            processNode = nodeArray[n2];
            for (List connections : processNode.getIncomingConnections().values()) {
                for (Connection connection : connections) {
                    org.eclipse.draw2d.graph.Node source = mapping.get(connection.getFrom().getId());
                    org.eclipse.draw2d.graph.Node target = mapping.get(connection.getTo().getId());
                    graph.edges.add((Object)new Edge(source, target));
                }
            }
            ++n2;
        }
        return graph;
    }
}

