/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.editor.editpart;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.DroolsPluginImages;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.figure.AbstractElementFigure;
import org.drools.eclipse.flow.ruleflow.core.WorkItemWrapper;
import org.drools.eclipse.flow.ruleflow.skin.SkinManager;
import org.drools.eclipse.flow.ruleflow.skin.SkinProvider;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.process.core.Work;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.WorkDefinitionExtension;
import org.drools.process.core.WorkEditor;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jbpm.workflow.core.node.WorkItemNode;

public class WorkItemEditPart
extends ElementEditPart {
    private String SKIN = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Flow.Skin");
    private static final Color color = new Color((Device)Display.getCurrent(), 255, 250, 205);

    protected IFigure createFigure() {
        IJavaProject javaProject;
        Image image;
        SkinProvider skinProvider = SkinManager.getInstance().getSkinProvider(this.SKIN);
        WorkItemFigureInterface figure = skinProvider.createWorkItemFigure();
        Rectangle constraint = this.getElementWrapper().getConstraint();
        if (constraint.width == -1) {
            constraint.width = figure.getSize().width;
        }
        if (constraint.height == -1) {
            constraint.height = figure.getSize().height;
        }
        this.getElementWrapper().setConstraint(constraint);
        String icon = null;
        WorkDefinition workDefinition = this.getWorkDefinition();
        if (workDefinition instanceof WorkDefinitionExtension) {
            icon = ((WorkDefinitionExtension)workDefinition).getIcon();
        }
        if (icon == null) {
            icon = "icons/action.gif";
        }
        if ((image = DroolsPluginImages.getImage(icon)) == null && (javaProject = this.getProject()) != null) {
            try {
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                URLClassLoader newLoader = ProjectClassLoader.getProjectClassLoader(javaProject);
                try {
                    Thread.currentThread().setContextClassLoader(newLoader);
                    image = ImageDescriptor.createFromURL((URL)newLoader.getResource(icon)).createImage();
                    DroolsPluginImages.putImage(icon, image);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            catch (Exception e) {
                DroolsEclipsePlugin.log(e);
            }
        }
        figure.setIcon(image);
        return figure;
    }

    protected WorkItemWrapper getWorkItemWrapper() {
        return (WorkItemWrapper)this.getElementWrapper();
    }

    private WorkDefinition getWorkDefinition() {
        return this.getWorkItemWrapper().getWorkDefinition();
    }

    @Override
    protected void doubleClicked() {
        Work work;
        String editor;
        super.doubleClicked();
        WorkDefinition workDefinition = this.getWorkDefinition();
        if (workDefinition instanceof WorkDefinitionExtension && (editor = ((WorkDefinitionExtension)workDefinition).getCustomEditor()) != null && (work = this.openEditor(editor, workDefinition)) != null) {
            SetWorkCommand setCommand = new SetWorkCommand();
            setCommand.setPropertyValue(work);
            CommandStack stack = this.getViewer().getEditDomain().getCommandStack();
            stack.execute((Command)setCommand);
        }
    }

    private Work openEditor(String editorClassName, WorkDefinition workDefinition) {
        IJavaProject javaProject = this.getProject();
        if (javaProject != null) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader newLoader = ProjectClassLoader.getProjectClassLoader(javaProject);
            try {
                Thread.currentThread().setContextClassLoader(newLoader);
                Class<?> editorClass = newLoader.loadClass(editorClassName);
                Constructor<?> constructor = editorClass.getConstructor(Shell.class);
                WorkEditor editor = (WorkEditor)constructor.newInstance(this.getViewer().getControl().getShell());
                editor.setWorkDefinition(workDefinition);
                WorkItemNode workItemNode = this.getWorkItemWrapper().getWorkItemNode();
                editor.setWork(workItemNode.getWork());
                boolean result = editor.show();
                Work work = result ? editor.getWork() : null;
                Thread.currentThread().setContextClassLoader(oldLoader);
                return work;
            }
            catch (Throwable throwable) {
                try {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    throw throwable;
                }
                catch (Exception e) {
                    DroolsEclipsePlugin.log(e);
                }
            }
        }
        return null;
    }

    private class SetWorkCommand
    extends Command {
        protected Work propertyValue;
        protected Work undoValue;
        protected IPropertySource target;

        public SetWorkCommand() {
            super("Set Work Value");
        }

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            this.undoValue = WorkItemEditPart.this.getWorkItemWrapper().getWorkItemNode().getWork();
            WorkItemEditPart.this.getWorkItemWrapper().getWorkItemNode().setWork(this.propertyValue);
        }

        public void redo() {
            this.execute();
        }

        public void setPropertyValue(Work val) {
            this.propertyValue = val;
        }

        public void undo() {
            WorkItemEditPart.this.getWorkItemWrapper().getWorkItemNode().setWork(this.undoValue);
        }
    }

    public static class WorkItemFigure
    extends AbstractElementFigure
    implements WorkItemFigureInterface {
        private RoundedRectangle rectangle;
        private ConnectionAnchor defaultConnectionAnchor;
        private List<ConnectionAnchor> outgoingConnectionAnchors = new ArrayList<ConnectionAnchor>();

        public WorkItemFigure() {
            this.defaultConnectionAnchor = new ChopboxAnchor((IFigure)this);
        }

        public void layoutConnectionAnchors() {
        }

        public ConnectionAnchor getOutgoingConnectionAnchorAt(Point p) {
            ConnectionAnchor closest = null;
            long min = Long.MAX_VALUE;
            for (ConnectionAnchor c : this.outgoingConnectionAnchors) {
                Point p2 = c.getLocation(null);
                long d = p.getDistance2(p2);
                if (d >= min) continue;
                min = d;
                closest = c;
            }
            if (min > 100L) {
                return this.defaultConnectionAnchor;
            }
            return closest;
        }

        @Override
        protected void customizeFigure() {
            this.rectangle = new RoundedRectangle();
            this.rectangle.setCornerDimensions(new Dimension(25, 25));
            this.add((IFigure)this.rectangle, 0);
            this.rectangle.setBackgroundColor(color);
            this.rectangle.setBounds(this.getBounds());
            this.setSelected(false);
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            super.setBounds(rectangle);
            this.rectangle.setBounds(rectangle);
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            this.rectangle.setLineWidth(b ? 3 : 1);
            this.repaint();
        }

        public void validate() {
            if (this.isValid()) {
                return;
            }
            this.layoutConnectionAnchors();
            super.validate();
        }
    }

    public static interface WorkItemFigureInterface
    extends IFigure {
        public void setIcon(Image var1);
    }
}

