/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.launching;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.debug.core.DroolsDebugModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.StandardVMDebugger;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class DroolsVMDebugger
extends StandardVMDebugger {
    public DroolsVMDebugger(IVMInstall vmInstance) {
        super(vmInstance);
    }

    /*
     * Unable to fully structure code
     */
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.StandardVMDebugger_Launching_VM____1, 4);
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Finding_free_socket____2);
        port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(LaunchingMessages.StandardVMDebugger_Could_not_find_a_free_socket_for_the_debugger_1, null, 118);
        }
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Constructing_command_line____3);
        program = this.constructProgramString(config);
        arguments = new ArrayList<String>(12);
        arguments.add(program);
        allVMArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(allVMArgs, arguments);
        arguments.add("-Dmvel.debugger=true");
        this.addBootClassPathArguments(arguments, config);
        cp = config.getClassPath();
        if (cp.length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(cp));
        }
        if ((version = this.getJavaVersion()) < 1.5) {
            arguments.add("-Xdebug");
            arguments.add("-Xnoagent");
        }
        if (version < 1.4) {
            arguments.add("-Djava.compiler=NONE");
        }
        if (version < 1.5) {
            arguments.add("-Xrunjdwp:transport=dt_socket,suspend=y,address=localhost:" + port);
        } else {
            arguments.add("-agentlib:jdwp=transport=dt_socket,suspend=y,address=localhost:" + port);
        }
        arguments.add(config.getClassToLaunch());
        this.addArguments(config.getProgramArguments(), arguments);
        cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        envp = config.getEnvironment();
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Starting_virtual_machine____4);
        connector = this.getConnector();
        if (connector == null) {
            this.abort(LaunchingMessages.StandardVMDebugger_Couldn__t_find_an_appropriate_debug_connector_2, null, 119);
        }
        map = connector.defaultArguments();
        this.specifyArguments(map, port);
        p = null;
        try {
            try {
                if (monitor.isCanceled()) {
                    return;
                }
                connector.startListening(map);
                workingDir = this.getWorkingDir(config);
                p = this.exec(cmdLine, workingDir, envp);
                if (p == null) {
                    return;
                }
                if (monitor.isCanceled()) {
                    p.destroy();
                    return;
                }
                process = this.newProcess(launch, p, DroolsVMDebugger.renderProcessLabel((String[])cmdLine), this.getDefaultProcessMap());
                process.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLineInternal(cmdLine));
                subMonitor.worked(1);
                subMonitor.subTask(LaunchingMessages.StandardVMDebugger_Establishing_debug_connection____5);
                retry = false;
                while (true) {
                    try {
                        runnable = new ConnectRunnable(connector, map);
                        connectThread = new Thread((Runnable)runnable, "Listening Connector");
                        connectThread.setDaemon(true);
                        connectThread.start();
                        while (connectThread.isAlive()) {
                            if (!monitor.isCanceled()) ** break block40
                            connector.stopListening(map);
                            p.destroy();
                            return;
                        }
                    }
                    catch (InterruptedIOException e) {
                        this.checkErrorMessage(process);
                        status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 117, "", (Throwable)e);
                        handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                        retry = false;
                        if (handler == null) {
                            throw new CoreException((IStatus)status);
                        }
                        result = handler.handleStatus((IStatus)status, (Object)this);
                        if (!(result instanceof Boolean)) continue;
                        retry = (Boolean)result;
                        if (retry) continue;
                        break;
                    }
                    {
                        try {
                            p.exitValue();
                            try {
                                connector.stopListening(map);
                            }
                            catch (IOException v0) {}
                            this.checkErrorMessage(process);
                        }
                        catch (IllegalThreadStateException v1) {}
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException v2) {}
                        continue;
                    }
                    ex = runnable.getException();
                    if (ex instanceof IllegalConnectorArgumentsException) {
                        throw (IllegalConnectorArgumentsException)ex;
                    }
                    if (ex instanceof InterruptedIOException) {
                        throw (InterruptedIOException)ex;
                    }
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    vm = runnable.getVirtualMachine();
                    if (vm != null) {
                        DroolsDebugModel.newDebugTarget(launch, vm, this.renderDebugTarget(config.getClassToLaunch(), port), process, true, false, config.isResumeOnStartup());
                        subMonitor.worked(1);
                        subMonitor.done();
                    }
                    return;
                }
            }
            finally {
                connector.stopListening(map);
            }
        }
        catch (IOException e) {
            this.abort(LaunchingMessages.StandardVMDebugger_Couldn__t_connect_to_VM_4, e, 120);
        }
        catch (IllegalConnectorArgumentsException e) {
            this.abort(LaunchingMessages.StandardVMDebugger_Couldn__t_connect_to_VM_5, e, 120);
        }
        if (p != null) {
            p.destroy();
        }
    }

    private String renderCommandLineInternal(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command.toString());
                buf.append('\"');
            } else {
                buf.append(command.toString());
            }
            ++i;
        }
        return buf.toString();
    }

    private double getJavaVersion() {
        LibraryInfo libInfo = LaunchingPlugin.getLibraryInfo((String)this.fVMInstance.getInstallLocation().getAbsolutePath());
        if (libInfo == null) {
            return 0.0;
        }
        String version = libInfo.getVersion();
        int index = version.indexOf(".");
        int nextIndex = version.indexOf(".", index + 1);
        try {
            if (index > 0 && nextIndex > index) {
                return Double.parseDouble(version.substring(0, nextIndex));
            }
            return Double.parseDouble(version);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    protected void checkErrorMessage(IProcess process) throws CoreException {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        if (streamsProxy != null) {
            String errorMessage = streamsProxy.getErrorStreamMonitor().getContents();
            if (errorMessage.length() == 0) {
                errorMessage = streamsProxy.getOutputStreamMonitor().getContents();
            }
            if (errorMessage.length() != 0) {
                this.abort(errorMessage, null, 116);
            }
        }
    }

    protected void specifyArguments(Map map, int portNumber) {
        Connector.IntegerArgument port = (Connector.IntegerArgument)map.get("port");
        port.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)map.get("timeout");
        if (timeoutArg != null) {
            int timeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            timeoutArg.setValue(timeout);
        }
    }

    protected ListeningConnector getConnector() {
        List<ListeningConnector> connectors = Bootstrap.virtualMachineManager().listeningConnectors();
        int i = 0;
        while (i < connectors.size()) {
            ListeningConnector c = connectors.get(i);
            if ("com.sun.jdi.SocketListen".equals(c.name())) {
                return c;
            }
            ++i;
        }
        return null;
    }

    class ConnectRunnable
    implements Runnable {
        private VirtualMachine fVirtualMachine = null;
        private ListeningConnector fConnector = null;
        private Map fConnectionMap = null;
        private Exception fException = null;

        public ConnectRunnable(ListeningConnector connector, Map map) {
            this.fConnector = connector;
            this.fConnectionMap = map;
        }

        @Override
        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IOException e) {
                this.fException = e;
            }
            catch (IllegalConnectorArgumentsException e) {
                this.fException = e;
            }
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

