/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DRLProblemAnnotation;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class DRLReconcilingStrategy
implements IReconcilingStrategy {
    private static final Pattern RULE_PATTERN = Pattern.compile("\\n\\s*(rule\\s+.*?\\n\\s*end)", 32);
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\n\\s*(template\\s+.*?\\n\\s*end)", 32);
    private static final Pattern QUERY_PATTERN = Pattern.compile("\\n\\s*(query\\s+.*?\\n\\s*end)", 32);
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("\\n\\s*(function\\s+[^\\{]*\\{)", 32);
    private static final Pattern IMPORT_PATTERN = Pattern.compile("\\n\\s*((\\s*import\\s+[^\\s;]+;?[\\t\\x0B\\f\\r]*\\n)+)", 32);
    private ISourceViewer sourceViewer;
    private AbstractRuleEditor editor;
    private IDocument document;
    private boolean folding;

    public DRLReconcilingStrategy(ISourceViewer sourceViewer, final AbstractRuleEditor editor) {
        this.sourceViewer = sourceViewer;
        this.editor = editor;
        IPreferenceStore preferenceStore = DroolsEclipsePlugin.getDefault().getPreferenceStore();
        this.folding = preferenceStore.getBoolean("Drools.EditorFolding");
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("Drools.EditorFolding".equals(event.getProperty())) {
                    DRLReconcilingStrategy.this.folding = (Boolean)event.getNewValue();
                    if (DRLReconcilingStrategy.this.folding) {
                        DRLReconcilingStrategy.this.reconcile();
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                editor.updateFoldingStructure(new ArrayList());
                            }
                        });
                    }
                }
            }
        });
    }

    public void setDocument(IDocument document) {
        this.document = document;
        this.reconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion region) {
        this.reconcile();
    }

    public void reconcile(IRegion region) {
        this.reconcile();
    }

    private void reconcile() {
        if (this.document != null) {
            String s = this.document.get();
            if (this.folding) {
                this.calculateFolding(s);
            }
        }
    }

    private static void createAnnotation(IFile file, IAnnotationModel annotationModel, String message, int offset, int length) {
        DRLProblemAnnotation annotation = new DRLProblemAnnotation(message);
        Position position = new Position(0, 1);
        annotationModel.addAnnotation((Annotation)annotation, position);
    }

    public static void removeAnnotationsFor(IAnnotationModel annotationModel) {
        Iterator iterator = annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof DRLProblemAnnotation)) continue;
            annotationModel.removeAnnotation(annotation);
        }
    }

    protected void calculateFolding(String input) {
        final ArrayList<Position> positions = new ArrayList<Position>();
        Matcher matcher = RULE_PATTERN.matcher(input);
        while (matcher.find()) {
            positions.add(new Position(matcher.start(1), matcher.end(1) - matcher.start(1)));
        }
        matcher = QUERY_PATTERN.matcher(input);
        while (matcher.find()) {
            positions.add(new Position(matcher.start(1), matcher.end(1) - matcher.start(1)));
        }
        matcher = TEMPLATE_PATTERN.matcher(input);
        while (matcher.find()) {
            positions.add(new Position(matcher.start(1), matcher.end(1) - matcher.start(1)));
        }
        matcher = IMPORT_PATTERN.matcher(input);
        while (matcher.find()) {
            positions.add(new Position(matcher.start(1), matcher.end(1) - matcher.start(1)));
        }
        matcher = FUNCTION_PATTERN.matcher(input);
        block4: while (matcher.find()) {
            int start = matcher.start(1);
            int nbOpenBrackets = 1;
            int i = matcher.end();
            while (i < input.length()) {
                if (input.charAt(i) == '{') {
                    ++nbOpenBrackets;
                } else if (input.charAt(i) == '}' && --nbOpenBrackets == 0) {
                    positions.add(new Position(start, i - start + 1));
                    continue block4;
                }
                ++i;
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DRLReconcilingStrategy.this.editor.updateFoldingStructure(positions);
            }
        });
    }
}

