/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DroolsClasspathContainer;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.wizard.project.NewDroolsProjectRuntimeWizardPage;
import org.drools.eclipse.wizard.project.NewDroolsProjectWizardPage;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewDroolsProjectWizard
extends BasicNewResourceWizard {
    public static final String DROOLS_CLASSPATH_CONTAINER_PATH = "DROOLS/Drools";
    private IProject newProject;
    private WizardNewProjectCreationPage mainPage;
    private NewDroolsProjectWizardPage extraPage;
    private NewDroolsProjectRuntimeWizardPage runtimePage;
    List<String> list = new ArrayList<String>();

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle("New Drools Project");
        this.mainPage.setDescription("Create a new Drools Project");
        this.addPage((IWizardPage)this.mainPage);
        this.extraPage = new NewDroolsProjectWizardPage();
        this.addPage((IWizardPage)this.extraPage);
        this.runtimePage = new NewDroolsProjectRuntimeWizardPage();
        this.addPage((IWizardPage)this.runtimePage);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.createDroolsProject();
        if (this.newProject == null) {
            return false;
        }
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    private void createDroolsProject() {
        this.newProject = this.createNewProject();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    IJavaProject project = JavaCore.create((IProject)NewDroolsProjectWizard.this.newProject);
                    NewDroolsProjectWizard.this.createDroolsRuntime(project, monitor);
                    NewDroolsProjectWizard.this.createOutputLocation(project, monitor);
                    NewDroolsProjectWizard.this.addJavaBuilder(project, monitor);
                    NewDroolsProjectWizard.this.setClasspath(project, monitor);
                    NewDroolsProjectWizard.this.createInitialContent(project, monitor);
                    NewDroolsProjectWizard.this.newProject.build(6, monitor);
                }
                catch (IOException iOException) {
                    ErrorDialog.openError((Shell)NewDroolsProjectWizard.this.getShell(), (String)"Problem creating Drools project", null, null);
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        this.addNatures(description);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewDroolsProjectWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"NewProject.errorMessage", (String)("NewProject.caseVariantExistsError" + newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"NewProject.errorMessage", null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                DroolsEclipsePlugin.log(e);
            }
            return null;
        }
        return newProjectHandle;
    }

    private void addNatures(IProjectDescription projectDescription) {
        this.list.addAll(Arrays.asList(projectDescription.getNatureIds()));
        this.list.add("org.eclipse.jdt.core.javanature");
        projectDescription.setNatureIds(this.list.toArray(new String[this.list.size()]));
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    private void createDroolsRuntime(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        DroolsRuntime runtime = this.runtimePage.getDroolsRuntime();
        if (runtime != null) {
            IFile file = project.getProject().getFile(".settings/.drools.runtime");
            String runtimeString = "<runtime>" + runtime.getName() + "</runtime>";
            if (!file.exists()) {
                IFolder folder = project.getProject().getFolder(".settings");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                file.create((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, null);
            } else {
                file.setContents((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, false, null);
            }
        }
    }

    private void createOutputLocation(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IFolder folder = this.createFolder(project, "target", monitor);
        IPath path = folder.getFullPath();
        project.setOutputLocation(path, null);
    }

    private void addJavaBuilder(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 2];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand javaCommand = description.newCommand();
        javaCommand.setBuilderName("org.eclipse.jdt.core.javabuilder");
        newCommands[commands.length] = javaCommand;
        ICommand droolsCommand = description.newCommand();
        droolsCommand.setBuilderName("org.drools.eclipse.droolsbuilder");
        newCommands[commands.length + 1] = droolsCommand;
        description.setBuildSpec(newCommands);
        project.getProject().setDescription(description, monitor);
    }

    private void setClasspath(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        project.setRawClasspath(new IClasspathEntry[0], monitor);
        this.addSourceFolders(project, monitor);
        this.addJRELibraries(project, monitor);
        NewDroolsProjectWizard.addDroolsLibraries(project, monitor);
    }

    private void addSourceFolders(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        this.addSourceFolder(project, list, "src/main/java", monitor);
        if (this.runtimePage.getGenerationType() == "Drools 6.0.x") {
            this.addSourceFolder(project, list, "src/main/resources", monitor);
            this.createFolder(project, "src/main/resources/META-INF", monitor);
            this.createFolder(project, "src/main/resources/META-INF/maven", monitor);
        } else {
            this.addSourceFolder(project, list, "src/main/rules", monitor);
        }
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), null);
    }

    private void addJRELibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        list.addAll(Arrays.asList(PreferenceConstants.getDefaultJRELibrary()));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
    }

    private static IPath getClassPathContainerPath() {
        return new Path(DROOLS_CLASSPATH_CONTAINER_PATH);
    }

    private static void createDroolsLibraryContainer(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        JavaCore.setClasspathContainer((IPath)NewDroolsProjectWizard.getClassPathContainerPath(), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{new DroolsClasspathContainer(project, NewDroolsProjectWizard.getClassPathContainerPath())}, (IProgressMonitor)monitor);
    }

    public static void addDroolsLibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        NewDroolsProjectWizard.createDroolsLibraryContainer(project, monitor);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        list.add(JavaCore.newContainerEntry((IPath)NewDroolsProjectWizard.getClassPathContainerPath()));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
    }

    private void createInitialContent(IJavaProject project, IProgressMonitor monitor) throws CoreException, JavaModelException, IOException {
        try {
            boolean createKModule = false;
            if (this.extraPage.createJavaRuleFile()) {
                this.createRuleSampleLauncher(project);
                createKModule = true;
            }
            if (this.extraPage.createRuleFile()) {
                this.createRule(project, monitor);
                createKModule = true;
            }
            if (this.extraPage.createDecisionTableFile()) {
                this.createDecisionTable(project, monitor);
                createKModule = true;
            }
            if (this.extraPage.createJavaDecisionTableFile()) {
                this.createDecisionTableSampleLauncher(project);
                createKModule = true;
            }
            if (this.extraPage.createRuleFlowFile()) {
                this.createRuleFlow(project, monitor);
                createKModule = true;
            }
            if (this.extraPage.createJavaRuleFlowFile()) {
                this.createRuleFlowSampleLauncher(project);
                createKModule = true;
            }
            if (createKModule) {
                this.createKModule(project, monitor);
                this.createPom(project, monitor);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void createRuleSampleLauncher(IJavaProject project) throws JavaModelException, IOException {
        if (this.runtimePage.getGenerationType() == "Drools 4.x") {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/RuleLauncherSample_4.java.template", "DroolsTest.java");
        } else if (this.runtimePage.getGenerationType() == "Drools 5.0.x" || this.runtimePage.getGenerationType() == "Drools 5.1.x or above") {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/RuleLauncherSample_5.java.template", "DroolsTest.java");
        } else {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/RuleLauncherSample_6.java.template", "DroolsTest.java");
        }
    }

    private void createDecisionTableSampleLauncher(IJavaProject project) throws JavaModelException, IOException {
        if (this.runtimePage.getGenerationType() == "Drools 4.x") {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_4.java.template", "DecisionTableTest.java");
        } else if (this.runtimePage.getGenerationType() == "Drools 5.0.x" || this.runtimePage.getGenerationType() == "Drools 5.1.x or above") {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_5.java.template", "DecisionTableTest.java");
        } else {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_6.java.template", "DecisionTableTest.java");
        }
    }

    private void createProjectJavaFile(IJavaProject project, String templateFile, String javaFile) throws JavaModelException, IOException {
        IFolder folder = project.getProject().getFolder("src/main/java");
        IPackageFragmentRoot packageFragmentRoot = project.getPackageFragmentRoot((IResource)folder);
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment("com.sample", true, null);
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(templateFile);
        packageFragment.createCompilationUnit(javaFile, new String(this.readStream(inputstream)), true, null);
    }

    private void createProjectFile(IJavaProject project, IProgressMonitor monitor, String templateFile, String folderName, String fileName) throws CoreException {
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(templateFile);
        this.createProjectFile(project, monitor, inputstream, folderName, fileName);
    }

    private void createProjectFile(IJavaProject project, IProgressMonitor monitor, InputStream inputstream, String folderName, String fileName) throws CoreException {
        IFolder folder = project.getProject().getFolder(folderName);
        IFile file = folder.getFile(fileName);
        if (!file.exists()) {
            file.create(inputstream, true, monitor);
        } else {
            file.setContents(inputstream, true, false, monitor);
        }
    }

    private void createRule(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (this.runtimePage.getGenerationType() == "Drools 6.0.x") {
            this.createFolder(project, "src/main/resources/rules", monitor);
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.drl.template", "src/main/resources/rules", "Sample.drl");
        } else {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.drl.template", "src/main/rules", "Sample.drl");
        }
    }

    private void createKModule(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (this.runtimePage.getGenerationType() == "Drools 6.0.x") {
            this.createProjectFile(project, monitor, this.generateKModule(), "src/main/resources/META-INF", "kmodule.xml");
        }
    }

    private void createPom(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (this.runtimePage.getGenerationType() == "Drools 6.0.x") {
            this.createProjectFile(project, monitor, this.generatePomProperties(this.runtimePage.getGroupId(), this.runtimePage.getArtifactId(), this.runtimePage.getVersion()), "src/main/resources/META-INF/maven", "pom.properties");
        }
    }

    private void createDecisionTable(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (this.runtimePage.getGenerationType() == "Drools 6.0.x") {
            this.createFolder(project, "src/main/resources/dtables", monitor);
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.xls.template", "src/main/resources/dtables", "Sample.xls");
        } else {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.xls.template", "src/main/rules", "Sample.xls");
        }
    }

    private void createRuleFlow(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        String generationType = this.runtimePage.getGenerationType();
        if ("Drools 4.x".equals(generationType)) {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow_4.rf.template", "src/main/rules", "ruleflow.rf");
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow_4.rfm.template", "src/main/rules", "ruleflow.rfm");
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow_4.drl.template", "src/main/rules", "ruleflow.drl");
        } else if ("Drools 5.0.x".equals(generationType)) {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow.rf.template", "src/main/rules", "ruleflow.rf");
        } else if ("Drools 5.1.x or above".equals(generationType)) {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/sample.bpmn.template", "src/main/rules", "sample.bpmn");
        } else {
            this.createFolder(project, "src/main/resources/process", monitor);
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/sample.bpmn.template", "src/main/resources/process", "sample.bpmn");
        }
    }

    private void createRuleFlowSampleLauncher(IJavaProject project) throws JavaModelException, IOException {
        String generationType = this.runtimePage.getGenerationType();
        String s = "Drools 4.x".equals(generationType) ? "org/drools/eclipse/wizard/project/RuleFlowLauncherSample_4.java.template" : ("Drools 5.0.x".equals(generationType) ? "org/drools/eclipse/wizard/project/RuleFlowLauncherSample.java.template" : ("Drools 5.1.x or above".equals(generationType) ? "org/drools/eclipse/wizard/project/ProcessLauncherSample_bpmn_5.java.template" : "org/drools/eclipse/wizard/project/ProcessLauncherSample_bpmn_6.java.template"));
        this.createProjectJavaFile(project, s, "ProcessTest.java");
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = DroolsEclipsePlugin.getImageDescriptor("icons/drools-large.PNG");
        this.setDefaultPageImageDescriptor(desc);
    }

    private byte[] readStream(InputStream inputstream) throws IOException {
        byte[] bytes = null;
        int i = 0;
        byte[] tempBytes = new byte[1024];
        int j = inputstream.read(tempBytes);
        while (j != -1) {
            byte[] tempBytes2 = new byte[i + j];
            if (i > 0) {
                System.arraycopy(bytes, 0, tempBytes2, 0, i);
            }
            System.arraycopy(tempBytes, 0, tempBytes2, i, j);
            bytes = tempBytes2;
            i += j;
            j = inputstream.read(tempBytes);
        }
        return bytes;
    }

    private void addSourceFolder(IJavaProject project, List<IClasspathEntry> list, String s, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getProject().getFolder(s);
        this.createFolder(folder, monitor);
        IPackageFragmentRoot ipackagefragmentroot = project.getPackageFragmentRoot((IResource)folder);
        list.add(JavaCore.newSourceEntry((IPath)ipackagefragmentroot.getPath()));
    }

    private IFolder createFolder(IJavaProject project, String s, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getProject().getFolder(s);
        this.createFolder(folder, monitor);
        return folder;
    }

    private void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IContainer container = folder.getParent();
        if (container != null && !container.exists() && container instanceof IFolder) {
            this.createFolder((IFolder)container, monitor);
        }
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }

    private InputStream generateKModule() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kmodule xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n");
        if (this.extraPage.createJavaRuleFile() || this.extraPage.createRuleFile()) {
            sb.append("    <kbase name=\"rules\">\n");
            sb.append("        <ksession name=\"ksession-rules\"/>\n");
            sb.append("    </kbase>\n");
        }
        if (this.extraPage.createDecisionTableFile() || this.extraPage.createJavaDecisionTableFile()) {
            sb.append("    <kbase name=\"dtables\">\n");
            sb.append("        <ksession name=\"ksession-dtables\"/>\n");
            sb.append("    </kbase>\n");
        }
        if (this.extraPage.createRuleFlowFile() || this.extraPage.createJavaRuleFlowFile()) {
            sb.append("    <kbase name=\"process\">\n");
            sb.append("        <ksession name=\"ksession-process\"/>\n");
            sb.append("    </kbase>\n");
        }
        sb.append("</kmodule>\n");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private InputStream generatePom(String groupId, String artifactId, String version) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + groupId + "</groupId>\n" + "  <artifactId>" + artifactId + "</artifactId>\n" + "  <version>" + version + "</version>\n" + "</project>\n";
        return new ByteArrayInputStream(pom.getBytes());
    }

    private InputStream generatePomProperties(String groupId, String artifactId, String version) {
        String pom = "groupId=" + groupId + "\n" + "artifactId=" + artifactId + "\n" + "version=" + version + "\n";
        return new ByteArrayInputStream(pom.getBytes());
    }
}

