/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DroolsClasspathContainer;
import org.drools.eclipse.wizard.project.NewDroolsProjectRuntimeWizardPage;
import org.drools.eclipse.wizard.project.NewDroolsProjectWizardPage;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.kie.eclipse.wizard.project.AbstractKieProjectMainWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieProjectRuntimeWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieProjectWizard;

public class NewDroolsProjectWizard
extends AbstractKieProjectWizard {
    public static final String DROOLS_CLASSPATH_CONTAINER_PATH = "DROOLS/Drools";
    public static final String MAIN_PAGE = "extendedNewProjectPage";
    public static final String RUNTIME_PAGE = "extendedNewProjectRuntimePage";
    private NewDroolsProjectWizardPage mainPage;
    private NewDroolsProjectRuntimeWizardPage runtimePage;

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = DroolsEclipsePlugin.getImageDescriptor("icons/drools-large.PNG");
        this.setDefaultPageImageDescriptor(desc);
    }

    @Override
    protected void createOutputLocation(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IFolder folder = this.createFolder(project, "target", monitor);
        IPath path = folder.getFullPath();
        project.setOutputLocation(path, null);
    }

    @Override
    protected void addBuilders(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        super.addBuilders(project, monitor);
        this.addDroolsBuilder(project, monitor);
    }

    private void addDroolsBuilder(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand droolsCommand = description.newCommand();
        droolsCommand.setBuilderName("org.drools.eclipse.droolsbuilder");
        newCommands[commands.length] = droolsCommand;
        description.setBuildSpec(newCommands);
        project.getProject().setDescription(description, monitor);
    }

    private static IPath getClassPathContainerPath() {
        return new Path(DROOLS_CLASSPATH_CONTAINER_PATH);
    }

    @Override
    protected IClasspathContainer createClasspathContainer(IJavaProject project) {
        return new DroolsClasspathContainer(project, NewDroolsProjectWizard.getClassPathContainerPath());
    }

    private static void createDroolsLibraryContainer(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        JavaCore.setClasspathContainer((IPath)NewDroolsProjectWizard.getClassPathContainerPath(), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{new DroolsClasspathContainer(project, NewDroolsProjectWizard.getClassPathContainerPath())}, (IProgressMonitor)monitor);
    }

    public static void addDroolsLibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        NewDroolsProjectWizard.createDroolsLibraryContainer(project, monitor);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.addAll(Arrays.asList(project.getRawClasspath()));
        list.add(JavaCore.newContainerEntry((IPath)NewDroolsProjectWizard.getClassPathContainerPath()));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), monitor);
    }

    @Override
    protected boolean createInitialContent(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException, JavaModelException, IOException {
        if (!super.createInitialContent(javaProject, monitor)) {
            if (this.mainPage.getInitialProjectContent() == 0) {
                this.createKModule(javaProject, monitor);
                this.createPom(javaProject, monitor);
            } else if (this.mainPage.getInitialProjectContent() == 2) {
                try {
                    boolean createKModule = false;
                    if (this.mainPage.createJavaRuleFile()) {
                        this.createRuleSampleLauncher(javaProject);
                        createKModule = true;
                    }
                    if (this.mainPage.createRuleFile()) {
                        this.createRule(javaProject, monitor);
                        createKModule = true;
                    }
                    if (this.mainPage.createDecisionTableFile()) {
                        this.createDecisionTable(javaProject, monitor);
                        createKModule = true;
                    }
                    if (this.mainPage.createJavaDecisionTableFile()) {
                        this.createDecisionTableSampleLauncher(javaProject);
                        createKModule = true;
                    }
                    if (this.mainPage.createRuleFlowFile()) {
                        this.createRuleFlow(javaProject, monitor);
                        createKModule = true;
                    }
                    if (this.mainPage.createJavaRuleFlowFile()) {
                        this.createRuleFlowSampleLauncher(javaProject);
                        createKModule = true;
                    }
                    if (createKModule) {
                        this.createKModule(javaProject, monitor);
                        this.createPom(javaProject, monitor);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return true;
    }

    private void createRuleSampleLauncher(IJavaProject project) throws JavaModelException, IOException {
        String runtime = this.runtimePage.getRuntimeId();
        if ("org.drools.runtime_4.x".equals(runtime)) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/RuleLauncherSample_4.java.template", "DroolsTest.java");
        } else if ("org.drools.runtime_5.0.x".equals(runtime) || "org.drools.runtime_5.1.x".equals(runtime)) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/RuleLauncherSample_5.java.template", "DroolsTest.java");
        } else {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/RuleLauncherSample_6.java.template", "DroolsTest.java");
        }
    }

    private void createDecisionTableSampleLauncher(IJavaProject project) throws JavaModelException, IOException {
        String runtime = this.runtimePage.getRuntimeId();
        if ("org.drools.runtime_4.x".equals(runtime)) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_4.java.template", "DecisionTableTest.java");
        } else if ("org.drools.runtime_5.0.x".equals(runtime) || "org.drools.runtime_5.1.x".equals(runtime)) {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_5.java.template", "DecisionTableTest.java");
        } else {
            this.createProjectJavaFile(project, "org/drools/eclipse/wizard/project/DecisionTableLauncherSample_6.java.template", "DecisionTableTest.java");
        }
    }

    private void createProjectJavaFile(IJavaProject project, String templateFile, String javaFile) throws JavaModelException, IOException {
        IFolder folder = project.getProject().getFolder("src/main/java");
        IPackageFragmentRoot packageFragmentRoot = project.getPackageFragmentRoot((IResource)folder);
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment("com.sample", true, null);
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(templateFile);
        packageFragment.createCompilationUnit(javaFile, new String(this.readStream(inputstream)), true, null);
    }

    private void createProjectFile(IJavaProject project, IProgressMonitor monitor, String templateFile, String folderName, String fileName) throws CoreException {
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(templateFile);
        this.createProjectFile(project, monitor, inputstream, folderName, fileName);
    }

    private void createProjectFile(IJavaProject project, IProgressMonitor monitor, InputStream inputstream, String folderName, String fileName) throws CoreException {
        IFile file;
        if (folderName == null) {
            file = project.getProject().getFile(fileName);
        } else {
            IFolder folder = project.getProject().getFolder(folderName);
            file = folder.getFile(fileName);
        }
        if (!file.exists()) {
            file.create(inputstream, true, monitor);
        } else {
            file.setContents(inputstream, true, false, monitor);
        }
    }

    private void createRule(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if ("org.drools.runtime_6.x".equals(this.runtimePage.getRuntimeId())) {
            this.createFolder(project, "src/main/resources/rules", monitor);
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.drl.template", "src/main/resources/rules", "Sample.drl");
        } else {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.drl.template", "src/main/rules", "Sample.drl");
        }
    }

    private void createKModule(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if ("org.drools.runtime_6.x".equals(this.runtimePage.getRuntimeId())) {
            this.createProjectFile(project, monitor, this.generateKModule(), "src/main/resources/META-INF", "kmodule.xml");
        }
    }

    private void createPom(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if ("org.drools.runtime_6.x".equals(this.runtimePage.getRuntimeId())) {
            String groupId = this.runtimePage.getGroupId();
            String artifactId = this.runtimePage.getArtifactId();
            String version = this.runtimePage.getVersion();
            this.createProjectFile(project, monitor, this.generatePomProperties(groupId, artifactId, version), "src/main/resources/META-INF/maven", "pom.properties");
            this.createProjectFile(project, monitor, this.generatePom(groupId, artifactId, version), null, "pom.xml");
        }
    }

    private void createDecisionTable(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if ("org.drools.runtime_6.x".equals(this.runtimePage.getRuntimeId())) {
            this.createFolder(project, "src/main/resources/dtables", monitor);
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.xls.template", "src/main/resources/dtables", "Sample.xls");
        } else {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/Sample.xls.template", "src/main/rules", "Sample.xls");
        }
    }

    private void createRuleFlow(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        String runtimeId = this.runtimePage.getRuntimeId();
        if ("org.drools.runtime_4.x".equals(runtimeId)) {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow_4.rf.template", "src/main/rules", "ruleflow.rf");
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow_4.rfm.template", "src/main/rules", "ruleflow.rfm");
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow_4.drl.template", "src/main/rules", "ruleflow.drl");
        } else if ("org.drools.runtime_5.0.x".equals(runtimeId)) {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/ruleflow.rf.template", "src/main/rules", "ruleflow.rf");
        } else if ("org.drools.runtime_5.1.x".equals(runtimeId)) {
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/sample.bpmn.template", "src/main/rules", "sample.bpmn");
        } else {
            this.createFolder(project, "src/main/resources/process", monitor);
            this.createProjectFile(project, monitor, "org/drools/eclipse/wizard/project/sample.bpmn.template", "src/main/resources/process", "sample.bpmn");
        }
    }

    private void createRuleFlowSampleLauncher(IJavaProject project) throws JavaModelException, IOException {
        String runtimeId = this.runtimePage.getRuntimeId();
        String s = "org.drools.runtime_4.x".equals(runtimeId) ? "org/drools/eclipse/wizard/project/RuleFlowLauncherSample_4.java.template" : ("org.drools.runtime_5.0.x".equals(runtimeId) ? "org/drools/eclipse/wizard/project/RuleFlowLauncherSample.java.template" : ("org.drools.runtime_5.1.x".equals(runtimeId) ? "org/drools/eclipse/wizard/project/ProcessLauncherSample_bpmn_5.java.template" : "org/drools/eclipse/wizard/project/ProcessLauncherSample_bpmn_6.java.template"));
        this.createProjectJavaFile(project, s, "ProcessTest.java");
    }

    private byte[] readStream(InputStream inputstream) throws IOException {
        byte[] bytes = null;
        int i = 0;
        byte[] tempBytes = new byte[1024];
        int j = inputstream.read(tempBytes);
        while (j != -1) {
            byte[] tempBytes2 = new byte[i + j];
            if (i > 0) {
                System.arraycopy(bytes, 0, tempBytes2, 0, i);
            }
            System.arraycopy(tempBytes, 0, tempBytes2, i, j);
            bytes = tempBytes2;
            i += j;
            j = inputstream.read(tempBytes);
        }
        return bytes;
    }

    private InputStream generateKModule() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kmodule xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n");
        if (this.mainPage.createJavaRuleFile() || this.mainPage.createRuleFile()) {
            sb.append("    <kbase name=\"rules\" packages=\"rules\">\n");
            sb.append("        <ksession name=\"ksession-rules\"/>\n");
            sb.append("    </kbase>\n");
        }
        if (this.mainPage.createDecisionTableFile() || this.mainPage.createJavaDecisionTableFile()) {
            sb.append("    <kbase name=\"dtables\" packages=\"dtables\">\n");
            sb.append("        <ksession name=\"ksession-dtables\"/>\n");
            sb.append("    </kbase>\n");
        }
        if (this.mainPage.createRuleFlowFile() || this.mainPage.createJavaRuleFlowFile()) {
            sb.append("    <kbase name=\"process\" packages=\"process\">\n");
            sb.append("        <ksession name=\"ksession-process\"/>\n");
            sb.append("    </kbase>\n");
        }
        sb.append("</kmodule>\n");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private InputStream generatePom(String groupId, String artifactId, String version) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + groupId + "</groupId>\n" + "  <artifactId>" + artifactId + "</artifactId>\n" + "  <version>" + version + "</version>\n" + "</project>\n";
        return new ByteArrayInputStream(pom.getBytes());
    }

    private InputStream generatePomProperties(String groupId, String artifactId, String version) {
        String pom = "groupId=" + groupId + "\n" + "artifactId=" + artifactId + "\n" + "version=" + version + "\n";
        return new ByteArrayInputStream(pom.getBytes());
    }

    @Override
    protected AbstractKieProjectMainWizardPage createMainPage(String pageId) {
        if (this.mainPage == null) {
            this.mainPage = new NewDroolsProjectWizardPage(pageId);
        }
        return this.mainPage;
    }

    @Override
    protected AbstractKieProjectRuntimeWizardPage createRuntimePage(String pageId) {
        if (this.runtimePage == null) {
            this.runtimePage = new NewDroolsProjectRuntimeWizardPage(pageId);
        }
        return this.runtimePage;
    }
}

