/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.wizard.project;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.progress.IProgressService;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.utils.FileUtils;
import org.kie.eclipse.wizard.project.AbstractKieProjectRuntimeWizardPage;
import org.kie.eclipse.wizard.project.IUTreeViewer;
import org.osgi.framework.ServiceReference;

public abstract class AbstractKieProjectMainWizardPage
extends WizardNewProjectCreationPage {
    public static final int EMPTY_PROJECT = 0;
    public static final int ONLINE_EXAMPLE_PROJECT = 1;
    public static final int SAMPLE_FILES_PROJECT = 2;
    private static final String DEFAULT_REPOSITORY_ID = "org.drools.sample.project.jbpm-playground";
    private static final String DROOLS_SAMPLE_PROJECTS_REPOSITORY = "org.drools.eclipse.sampleProjectsRepository";
    private static final String DEFAULT_REPOSITORY_URL = "https://raw.githubusercontent.com/bbrodt/jbpm-playground/master/site/";
    private final Collection<IInstallableUnit> EMPTY_IU_LIST = new ArrayList<IInstallableUnit>();
    private AbstractKieProjectRuntimeWizardPage runtimePage;
    private Composite onlineExampleProjectGroup;
    private Button onlineExampleProjectButton;
    private Composite emptyProjectGroup;
    private Composite sampleFilesProjectGroup;
    private Button emptyProjectButton;
    private Button sampleFilesProjectButton;
    private Composite browserGroup;
    IQueryResult<IInstallableUnit> queryResult;
    private int initialProjectContent = 0;
    private IUTreeViewer onlineExamplesTree;
    private Collection<IInstallableUnit> installableUnits;
    private Browser browser;
    private ServiceReference<?> providerRef;
    private String repositoryUrl;

    public AbstractKieProjectMainWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.runtimePage = (AbstractKieProjectRuntimeWizardPage)this.getWizard().getPage("extendedNewProjectRuntimePage");
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createControls(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void showGroup(Composite group, boolean show) {
        if (group != null && !group.isDisposed()) {
            GridData gd = (GridData)group.getLayoutData();
            gd.exclude = !show;
            group.setVisible(show);
            if (show) {
                Point oldSize = this.getShell().getSize();
                Point newSize = this.getShell().computeSize(-1, -1, true);
                if (oldSize.x < newSize.x || oldSize.y < newSize.y) {
                    newSize.x = Math.max(oldSize.x, newSize.x);
                    newSize.y = Math.max(oldSize.y, newSize.y);
                    this.getShell().setSize(newSize);
                }
            }
            group.getParent().layout();
        }
    }

    private void createControls(Composite parent) {
        Label projectContentsLabel = new Label(parent, 0);
        projectContentsLabel.setText("Select the initial contents for this new Project:");
        projectContentsLabel.setLayoutData((Object)new GridData());
        Composite buttonGroup = new Composite(parent, 0);
        buttonGroup.setLayoutData((Object)new GridData());
        buttonGroup.setLayout((Layout)new GridLayout(2, false));
        this.emptyProjectButton = new Button(buttonGroup, 16400);
        this.emptyProjectButton.setText("Create an empty Project");
        GridData gd = new GridData(1);
        gd.horizontalIndent = 10;
        gd.horizontalSpan = 2;
        this.emptyProjectButton.setLayoutData((Object)gd);
        this.sampleFilesProjectButton = new Button(buttonGroup, 16400);
        this.sampleFilesProjectButton.setText("Populate the Project with sample files");
        gd = new GridData(1);
        gd.horizontalIndent = 10;
        gd.horizontalSpan = 2;
        this.sampleFilesProjectButton.setLayoutData((Object)gd);
        this.onlineExampleProjectButton = new Button(buttonGroup, 16400);
        this.onlineExampleProjectButton.setText("Download a sample Project from:");
        gd = new GridData(1);
        gd.horizontalIndent = 10;
        this.onlineExampleProjectButton.setLayoutData((Object)gd);
        final Combo repositoryCombo = new Combo(buttonGroup, 12);
        gd = new GridData(3);
        gd.horizontalIndent = 10;
        repositoryCombo.setLayoutData((Object)gd);
        repositoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = repositoryCombo.getSelectionIndex();
                if (index >= 0) {
                    AbstractKieProjectMainWizardPage.this.repositoryUrl = (String)repositoryCombo.getData(Integer.toString(index));
                    if (AbstractKieProjectMainWizardPage.this.onlineExampleProjectButton.getSelection()) {
                        AbstractKieProjectMainWizardPage.this.handleOnlineExampleProjectSelected();
                    }
                }
            }
        });
        this.fillRepositoryCombo(repositoryCombo);
        this.sampleFilesProjectGroup = new Composite(parent, 0);
        this.sampleFilesProjectGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        this.sampleFilesProjectGroup.setLayoutData((Object)gd);
        this.emptyProjectGroup = new Composite(parent, 0);
        this.emptyProjectGroup.setLayout((Layout)new GridLayout());
        this.emptyProjectGroup.setLayoutData((Object)new GridData(1808));
        this.onlineExampleProjectGroup = new Composite(parent, 0);
        this.onlineExampleProjectGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        this.onlineExampleProjectGroup.setLayoutData((Object)gd);
        this.emptyProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractKieProjectMainWizardPage.this.initialProjectContent == 0) {
                    return;
                }
                if (AbstractKieProjectMainWizardPage.this.emptyProjectButton.getSelection()) {
                    AbstractKieProjectMainWizardPage.this.initialProjectContent = 0;
                    AbstractKieProjectMainWizardPage.this.installableUnits = null;
                    AbstractKieProjectMainWizardPage.this.showGroup(AbstractKieProjectMainWizardPage.this.browserGroup, false);
                    AbstractKieProjectMainWizardPage.this.showGroup(AbstractKieProjectMainWizardPage.this.onlineExampleProjectGroup, false);
                    AbstractKieProjectMainWizardPage.this.showGroup(AbstractKieProjectMainWizardPage.this.sampleFilesProjectGroup, false);
                    AbstractKieProjectMainWizardPage.this.showGroup(AbstractKieProjectMainWizardPage.this.emptyProjectGroup, true);
                    AbstractKieProjectMainWizardPage.this.setPageComplete(AbstractKieProjectMainWizardPage.this.isPageComplete());
                }
            }
        });
        this.sampleFilesProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractKieProjectMainWizardPage.this.initialProjectContent == 2) {
                    return;
                }
                if (AbstractKieProjectMainWizardPage.this.sampleFilesProjectButton.getSelection()) {
                    AbstractKieProjectMainWizardPage.this.initialProjectContent = 2;
                    AbstractKieProjectMainWizardPage.this.installableUnits = null;
                    AbstractKieProjectMainWizardPage.this.showGroup(AbstractKieProjectMainWizardPage.this.browserGroup, false);
                    AbstractKieProjectMainWizardPage.this.showGroup(AbstractKieProjectMainWizardPage.this.onlineExampleProjectGroup, false);
                    AbstractKieProjectMainWizardPage.this.showGroup(AbstractKieProjectMainWizardPage.this.emptyProjectGroup, true);
                    AbstractKieProjectMainWizardPage.this.showGroup(AbstractKieProjectMainWizardPage.this.sampleFilesProjectGroup, true);
                    AbstractKieProjectMainWizardPage.this.setPageComplete(AbstractKieProjectMainWizardPage.this.isPageComplete());
                }
            }
        });
        this.onlineExampleProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractKieProjectMainWizardPage.this.initialProjectContent == 1) {
                    return;
                }
                if (AbstractKieProjectMainWizardPage.this.onlineExampleProjectButton.getSelection()) {
                    AbstractKieProjectMainWizardPage.this.handleOnlineExampleProjectSelected();
                }
            }
        });
        this.showGroup(this.emptyProjectGroup, true);
        this.showGroup(this.sampleFilesProjectGroup, false);
        this.showGroup(this.onlineExampleProjectGroup, false);
        this.emptyProjectButton.setSelection(true);
        this.createSampleFilesProjectControls(this.sampleFilesProjectGroup);
        this.createEmptyProjectControls(this.emptyProjectGroup);
    }

    private void fillRepositoryCombo(Combo repositoryCombo) {
        repositoryCombo.removeAll();
        try {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(DROOLS_SAMPLE_PROJECTS_REPOSITORY);
            int selectionIndex = -1;
            int index = 0;
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String id = e.getAttribute("id");
                String name = e.getAttribute("name");
                String url = e.getAttribute("url");
                String gitUrl = e.getAttribute("gitUrl");
                if (DEFAULT_REPOSITORY_ID.equals(id) && selectionIndex == -1) {
                    selectionIndex = index;
                }
                if (gitUrl != null) {
                    try {
                        Collection refs = Git.lsRemoteRepository().setHeads(true).setTags(true).setRemote(gitUrl).call();
                        if (refs.size() > 0) {
                            for (Ref ref : refs) {
                                String[] a = ref.getName().split("/");
                                if (a.length != 3) continue;
                                String tagUrl = null;
                                if ("heads".equals(a[1]) && url.contains("${BRANCH}")) {
                                    tagUrl = url.replace("${BRANCH}", a[2]);
                                } else if ("tags".equals(a[1]) && url.contains("${TAG}")) {
                                    tagUrl = url.replace("${TAG}", a[2]);
                                }
                                if (tagUrl == null) continue;
                                repositoryCombo.add(String.valueOf(name) + " (" + a[2] + ")");
                                repositoryCombo.setData(Integer.toString(index), (Object)tagUrl);
                                ++index;
                            }
                        } else {
                            gitUrl = null;
                        }
                    }
                    catch (InvalidRemoteException e2) {
                        gitUrl = null;
                        e2.printStackTrace();
                    }
                    catch (TransportException e2) {
                        gitUrl = null;
                        e2.printStackTrace();
                    }
                    catch (GitAPIException e2) {
                        gitUrl = null;
                        e2.printStackTrace();
                    }
                }
                if (gitUrl == null) {
                    repositoryCombo.add(name);
                    repositoryCombo.setData(Integer.toString(index), (Object)url);
                    ++index;
                }
                ++n2;
            }
            if (selectionIndex == -1) {
                selectionIndex = 0;
            }
            repositoryCombo.select(selectionIndex);
            this.repositoryUrl = (String)repositoryCombo.getData(Integer.toString(selectionIndex));
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.getMessage());
        }
    }

    private String getRepositoryUrl() {
        if (this.repositoryUrl != null) {
            return this.repositoryUrl;
        }
        return DEFAULT_REPOSITORY_URL;
    }

    private void createEmptyProjectControls(Composite parent) {
        super.createControl(parent);
    }

    protected abstract void createSampleFilesProjectControls(Composite var1);

    private String createOnlineExampleProjectControls(final Composite parent) {
        final String[] status = new String[1];
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) {
                    try {
                        IProvisioningAgent agent = AbstractKieProjectMainWizardPage.this.createProvisiongAgent();
                        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                        IMetadataRepository repository = manager.loadRepository(new URI(AbstractKieProjectMainWizardPage.this.getRepositoryUrl()), pm);
                        AbstractKieProjectMainWizardPage.this.queryResult = repository.query(QueryUtil.createIUAnyQuery(), pm);
                    }
                    catch (Exception ex) {
                        AbstractKieProjectMainWizardPage.this.disposeOnlineExampleProjectControls();
                        status[0] = ex.getMessage();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            status[0] = e.getMessage();
        }
        if (this.onlineExamplesTree == null) {
            this.onlineExamplesTree = new IUTreeViewer(parent, 2048);
            this.onlineExamplesTree.initialize();
            this.browserGroup = new Composite(parent, 2048);
            this.browserGroup.setLayout((Layout)new GridLayout());
            this.browserGroup.setLayoutData((Object)new GridData(1808));
            this.browser = new Browser(this.browserGroup, 0);
            this.browser.setLayoutData((Object)new GridData(1808));
            this.onlineExamplesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IInstallableUnit iu = (IInstallableUnit)e.data;
                    boolean browserLoaded = true;
                    try {
                        iu.getFilter();
                        String text = iu.getProperty("org.eclipse.equinox.p2.description", "df_LT");
                        String url = iu.getProperty("org.eclipse.equinox.p2.description.url");
                        if (text != null && !text.isEmpty()) {
                            AbstractKieProjectMainWizardPage.this.browser.setText(text);
                        } else if (AbstractKieProjectMainWizardPage.this.testURL(url)) {
                            AbstractKieProjectMainWizardPage.this.browser.setUrl(url);
                        } else {
                            AbstractKieProjectMainWizardPage.this.browser.setText("<html><body>No description is available for <b>" + iu.getProperty("org.eclipse.equinox.p2.name") + "</b></body></html>");
                        }
                    }
                    catch (Exception exception) {
                        browserLoaded = false;
                        MessageDialog.openError((Shell)AbstractKieProjectMainWizardPage.this.getShell(), (String)"Error", (String)"Cannot initialize Browser");
                    }
                    AbstractKieProjectMainWizardPage.this.showGroup(AbstractKieProjectMainWizardPage.this.browserGroup, browserLoaded);
                    AbstractKieProjectMainWizardPage.this.onlineExamplesTree.getTree().pack();
                    parent.layout();
                    AbstractKieProjectMainWizardPage.this.installableUnits = AbstractKieProjectMainWizardPage.this.onlineExamplesTree.getSelectedIUs();
                    AbstractKieProjectMainWizardPage.this.setPageComplete(AbstractKieProjectMainWizardPage.this.isPageComplete());
                }
            });
        }
        this.onlineExamplesTree.setInput(this.queryResult);
        this.showGroup(this.browserGroup, false);
        this.browser.setText("");
        if (this.onlineExamplesTree.getTree().getItemCount() == 0) {
            this.disposeOnlineExampleProjectControls();
            return "No examples were found in the repository.";
        }
        return null;
    }

    private void handleOnlineExampleProjectSelected() {
        String error = this.createOnlineExampleProjectControls(this.onlineExampleProjectGroup);
        if (error == null) {
            this.initialProjectContent = 1;
            this.showGroup(this.emptyProjectGroup, false);
            this.showGroup(this.browserGroup, false);
            this.showGroup(this.onlineExampleProjectGroup, true);
            this.showGroup(this.sampleFilesProjectGroup, false);
            this.installableUnits = this.onlineExamplesTree.getSelectedIUs();
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)NLS.bind((String)"Unable to load online examples from\n{0}\nCause:\n{1}", (Object)this.getRepositoryUrl(), (Object)error));
            this.onlineExampleProjectButton.setSelection(false);
            if (this.initialProjectContent == 0) {
                this.emptyProjectButton.setSelection(true);
            } else {
                this.sampleFilesProjectButton.setSelection(true);
            }
            this.installableUnits = null;
        }
        this.setPageComplete(this.isPageComplete());
    }

    private void disposeOnlineExampleProjectControls() {
        if (this.onlineExamplesTree != null) {
            if (!this.onlineExamplesTree.getTree().isDisposed()) {
                this.onlineExamplesTree.dispose();
            }
            this.onlineExamplesTree = null;
        }
        if (this.browser != null) {
            if (!this.browser.isDisposed()) {
                this.browser.dispose();
            }
            this.browser = null;
        }
    }

    public String downloadOnlineExampleProject(IProject project, IProgressMonitor monitor) {
        String projectName = project.getName();
        try {
            for (IInstallableUnit iu : this.getInstallableUnits()) {
                if (!projectName.equals(iu.getId())) continue;
                for (IArtifactKey k : iu.getArtifacts()) {
                    String filename = String.valueOf(k.getId()) + "_" + k.getVersion() + ".jar";
                    URL url = new URL(String.valueOf(this.getRepositoryUrl()) + "/plugins/" + filename);
                    File jarFile = FileUtils.downloadFile(url, monitor);
                    FileUtils.extractJarFile(jarFile, project, monitor);
                    jarFile.delete();
                    project.refreshLocal(2, monitor);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    private boolean testURL(String urlString) {
        boolean result = true;
        HttpURLConnection httpConnection = null;
        try {
            try {
                URL url = new URL(urlString);
                httpConnection = (HttpURLConnection)url.openConnection();
                httpConnection.getContent();
                httpConnection.disconnect();
                httpConnection = null;
            }
            catch (UnknownHostException unknownHostException) {
                result = false;
                if (httpConnection != null) {
                    httpConnection.disconnect();
                }
            }
            catch (IOException iOException) {
                result = false;
                if (httpConnection != null) {
                    httpConnection.disconnect();
                }
            }
        }
        finally {
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
        }
        return result;
    }

    public int getInitialProjectContent() {
        return this.initialProjectContent;
    }

    public Collection<IInstallableUnit> getInstallableUnits() {
        if (this.installableUnits == null) {
            return this.EMPTY_IU_LIST;
        }
        return this.installableUnits;
    }

    public Collection<IProjectDescription> getNewProjectDescriptions() {
        ArrayList<IProjectDescription> result = new ArrayList<IProjectDescription>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.initialProjectContent == 1) {
            for (IInstallableUnit iu : this.getInstallableUnits()) {
                String name = iu.getId();
                IProject project = this.getProjectHandle(name);
                IProjectDescription description = workspace.newProjectDescription(project.getName());
                result.add(description);
            }
        } else {
            IProject project = this.getProjectHandle();
            IPath newPath = this.useDefaults() ? null : this.getLocationPath();
            IProjectDescription description = workspace.newProjectDescription(project.getName());
            description.setLocation(newPath);
            result.add(description);
        }
        return result;
    }

    private IProject getProjectHandle(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public IRuntime getRuntime() {
        return this.runtimePage.getRuntime();
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        if (this.runtimePage != null) {
            this.runtimePage.setPageComplete(this.getInitialProjectContent() == 1);
        }
        if (this.isCurrentPage()) {
            this.getContainer().updateButtons();
        }
    }

    public boolean isPageComplete() {
        if (this.getInitialProjectContent() == 1) {
            return this.getInstallableUnits().size() > 0;
        }
        return super.validatePage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setPageComplete(this.isPageComplete());
        }
    }

    public boolean canFlipToNextPage() {
        if (this.getInitialProjectContent() == 1) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public void dispose() {
        if (this.providerRef != null) {
            DroolsEclipsePlugin.getContext().ungetService(this.providerRef);
            this.providerRef = null;
        }
        super.dispose();
    }

    private IProvisioningAgent createProvisiongAgent() throws ProvisionException {
        IProvisioningAgent result = null;
        this.providerRef = DroolsEclipsePlugin.getContext().getServiceReference(IProvisioningAgentProvider.SERVICE_NAME);
        if (this.providerRef == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)DroolsEclipsePlugin.getContext().getService(this.providerRef);
        if (provider == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        result = provider.createAgent(null);
        return result;
    }
}

