/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.skin;

import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.flow.ruleflow.skin.BPMN2SkinProvider;
import org.drools.eclipse.flow.ruleflow.skin.BPMNSkinProvider;
import org.drools.eclipse.flow.ruleflow.skin.DefaultSkinProvider;
import org.drools.eclipse.flow.ruleflow.skin.SkinProvider;

public final class SkinManager {
    private static final SkinManager INSTANCE = new SkinManager();
    private Map<String, SkinProvider> skinProviders = new HashMap<String, SkinProvider>();

    private SkinManager() {
        this.registerSkinProviders();
    }

    public static SkinManager getInstance() {
        return INSTANCE;
    }

    private void registerSkinProviders() {
        this.skinProviders.put("default", new DefaultSkinProvider());
        this.skinProviders.put("BPMN", new BPMNSkinProvider());
        this.skinProviders.put("BPMN2", new BPMN2SkinProvider());
    }

    public SkinProvider getSkinProvider(String type) {
        return this.skinProviders.get(type);
    }
}

