/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewRuleFlowFilePage
extends WizardNewFileCreationPage {
    private IWorkbench workbench;
    private String targetRuntime;

    public NewRuleFlowFilePage(IWorkbench workbench, IStructuredSelection selection) {
        super("createRuleFlowPage", selection);
        this.setTitle("Create Flow File");
        this.setDescription("Create a new Flow file");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setPageComplete(true);
    }

    public void setTargetRuntime(String targetRuntime) {
        this.targetRuntime = targetRuntime;
    }

    public boolean finish() {
        IFile newFile;
        String fileName = this.getFileName();
        if ("Drools 5.0.x".equals(this.targetRuntime)) {
            if (!fileName.endsWith(".rf")) {
                this.setFileName(String.valueOf(fileName) + ".rf");
            }
        } else if ("Drools 5.1.x or higher".equals(this.targetRuntime) && !fileName.endsWith(".bpmn")) {
            this.setFileName(String.valueOf(fileName) + ".bpmn");
        }
        if ((newFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        if ("Drools 5.0.x".equals(this.targetRuntime)) {
            String s = "org/drools/eclipse/flow/ruleflow/SampleRuleFlow.rf.template";
            return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(s);
        }
        if ("Drools 5.1.x or higher".equals(this.targetRuntime)) {
            String s = "org/drools/eclipse/flow/bpmn2/Sample.bpmn.template";
            return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(s);
        }
        throw new IllegalArgumentException("Unknown target runtime " + this.targetRuntime);
    }
}

