/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowConstraintDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.node.Split;
import org.kie.api.definition.process.Connection;

public class ConstraintListDialog
extends EditBeanDialog<Map<ConnectionRef, Constraint>> {
    private WorkflowProcess process;
    private Split split;
    private Map<ConnectionRef, Constraint> newMap;
    private Map<Connection, Label> labels = new HashMap<Connection, Label>();

    protected ConstraintListDialog(Shell parentShell, WorkflowProcess process, Split split) {
        super(parentShell, "Edit Constraints");
        this.process = process;
        this.split = split;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        List outgoingConnections = this.split.getDefaultOutgoingConnections();
        this.labels.clear();
        for (Connection outgoingConnection : outgoingConnections) {
            Label label1 = new Label(composite, 0);
            label1.setText("To node " + outgoingConnection.getTo().getName() + ": ");
            Label label2 = new Label(composite, 0);
            this.labels.put(outgoingConnection, label2);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            label2.setLayoutData((Object)gridData);
            Constraint constraint = this.newMap.get(new ConnectionRef(outgoingConnection.getTo().getId(), outgoingConnection.getToType()));
            if (constraint != null) {
                label2.setText(constraint.getName());
            }
            Button editButton = new Button(composite, 0);
            editButton.setText("Edit");
            editButton.addSelectionListener((SelectionListener)new EditButtonListener(outgoingConnection));
        }
        return composite;
    }

    @Override
    public void setValue(Map<ConnectionRef, Constraint> value) {
        super.setValue(value);
        this.newMap = new HashMap<ConnectionRef, Constraint>(value);
    }

    @Override
    protected Map<ConnectionRef, Constraint> updateValue(Map<ConnectionRef, Constraint> value) {
        return this.newMap;
    }

    private void editItem(final Connection connection) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RuleFlowConstraintDialog dialog = new RuleFlowConstraintDialog(ConstraintListDialog.this.getShell(), ConstraintListDialog.this.process);
                dialog.create();
                ConnectionRef connectionRef = new ConnectionRef(connection.getTo().getId(), connection.getToType());
                Constraint constraint = (Constraint)ConstraintListDialog.this.newMap.get(connectionRef);
                dialog.setConstraint(constraint);
                int code = dialog.open();
                if (code != 1) {
                    constraint = dialog.getConstraint();
                    ConstraintListDialog.this.newMap.put(connectionRef, constraint);
                    ConstraintListDialog.this.setConnectionText((Label)ConstraintListDialog.this.labels.get(connection), constraint.getName());
                }
            }
        };
        r.run();
    }

    private void setConnectionText(final Label connection, final String name) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                connection.setText(name);
            }
        });
    }

    private class EditButtonListener
    extends SelectionAdapter {
        private Connection connection;

        public EditButtonListener(Connection connection) {
            this.connection = connection;
        }

        public void widgetSelected(SelectionEvent e) {
            ConstraintListDialog.this.editItem(this.connection);
        }
    }
}

