/*
 * Decompiled with CFR 0.152.
 */
package org.drools.osgi.integrationtests;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactoryService;
import org.drools.osgi.test.AbstractDroolsSpringDMTest;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.util.ServiceRegistry;
import org.junit.Test;
import org.osgi.framework.ServiceReference;

public class BPMN2OsgiTest
extends AbstractDroolsSpringDMTest {
    protected void onSetUp() throws Exception {
        ServiceReference kbuilderRef = this.bundleContext.getServiceReference(KnowledgeBuilderFactoryService.class.getName());
        Thread.currentThread().setContextClassLoader(this.bundleContext.getService(kbuilderRef).getClass().getClassLoader());
    }

    protected void onTearDown() throws Exception {
    }

    @Test
    public void testMinimalProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcess.xml");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        BPMN2OsgiTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    private KnowledgeBase createKnowledgeBase(String process) throws Exception {
        ServiceReference serviceRef = this.bundleContext.getServiceReference(ServiceRegistry.class.getName());
        ServiceRegistry registry = (ServiceRegistry)this.bundleContext.getService(serviceRef);
        KnowledgeBuilderFactoryService knowledgeBuilderFactoryService = (KnowledgeBuilderFactoryService)registry.get(KnowledgeBuilderFactoryService.class);
        KnowledgeBaseFactoryService knowledgeBaseFactoryService = (KnowledgeBaseFactoryService)registry.get(KnowledgeBaseFactoryService.class);
        ResourceFactoryService resourceFactoryService = (ResourceFactoryService)registry.get(ResourceFactoryService.class);
        KnowledgeBuilder kbuilder = knowledgeBuilderFactoryService.newKnowledgeBuilder();
        kbuilder.add(resourceFactoryService.newClassPathResource(process, BPMN2OsgiTest.class), ResourceType.BPMN2);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base:\n" + kbuilder.getErrors());
        }
        KnowledgeBase kbase = knowledgeBaseFactoryService.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

