/*
 * Decompiled with CFR 0.152.
 */
package org.drools.osgi.integrationtests;

import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactoryService;
import org.drools.osgi.test.AbstractDroolsSpringDMTest;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.util.ServiceRegistry;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.test.Cheese;
import org.test.Person;
import org.test.decisiontable.Dummy;

public class SimpleOsgiTest
extends AbstractDroolsSpringDMTest {
    protected void onSetUp() throws Exception {
        ServiceReference kbuilderRef = this.bundleContext.getServiceReference(KnowledgeBuilderFactoryService.class.getName());
        Thread.currentThread().setContextClassLoader(this.bundleContext.getService(kbuilderRef).getClass().getClassLoader());
        System.out.println("setup" + this.bundleContext.getService(kbuilderRef).getClass().getClassLoader());
    }

    protected void onTearDown() throws Exception {
    }

    @Test
    public void testOsgiPlatformStarts() throws Exception {
        System.out.println(this.bundleContext.getProperty("org.osgi.framework.vendor"));
        System.out.println(this.bundleContext.getProperty("org.osgi.framework.version"));
        System.out.println(this.bundleContext.getProperty("org.osgi.framework.executionenvironment"));
    }

    @Test
    public void testOsgiEnvironment() throws Exception {
        Bundle[] bundles = this.bundleContext.getBundles();
        System.out.println("bundles: ");
        for (int i = 0; i < bundles.length; ++i) {
            System.out.print(bundles[i].getSymbolicName() + ":" + bundles[i].getState());
            System.out.print(", ");
        }
        System.out.println();
    }

    @Test
    public void testCompiler() {
        ServiceReference serviceRef = this.bundleContext.getServiceReference(ServiceRegistry.class.getName());
        ServiceRegistry registry = (ServiceRegistry)this.bundleContext.getService(serviceRef);
        KnowledgeBuilderFactoryService knowledgeBuilderFactoryService = (KnowledgeBuilderFactoryService)registry.get(KnowledgeBuilderFactoryService.class);
        KnowledgeBaseFactoryService knowledgeBaseFactoryService = (KnowledgeBaseFactoryService)registry.get(KnowledgeBaseFactoryService.class);
        ResourceFactoryService resourceFactoryService = (ResourceFactoryService)registry.get(ResourceFactoryService.class);
        String str = "";
        str = str + "package org.test\n";
        str = str + "import org.test.Person\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "    $p : Person( age > 30 )\n";
        str = str + "then\n";
        str = str + "    list.add($p);\n";
        str = str + "end\n";
        KnowledgeBuilderConfiguration kbConf = knowledgeBuilderFactoryService.newKnowledgeBuilderConfiguration(null, new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()});
        KnowledgeBuilder kbuilder = knowledgeBuilderFactoryService.newKnowledgeBuilder(kbConf);
        ResourceFactoryService resource = resourceFactoryService;
        kbuilder.add(resource.newByteArrayResource(str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kbaseConf = knowledgeBaseFactoryService.newKnowledgeBaseConfiguration(null, new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()});
        KnowledgeBase kbase = knowledgeBaseFactoryService.newKnowledgeBase(kbaseConf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("name", 34));
        ksession.fireAllRules();
        ksession.dispose();
        SimpleOsgiTest.assertEquals((int)1, (int)list.size());
        SimpleOsgiTest.assertEquals((Object)new Person("name", 34), list.get(0));
    }

    @Test
    public void testDecisionTable() {
        ServiceReference serviceRef = this.bundleContext.getServiceReference(ServiceRegistry.class.getName());
        ServiceRegistry registry = (ServiceRegistry)this.bundleContext.getService(serviceRef);
        KnowledgeBuilderFactoryService knowledgeBuilderFactoryService = (KnowledgeBuilderFactoryService)registry.get(KnowledgeBuilderFactoryService.class);
        KnowledgeBaseFactoryService knowledgeBaseFactoryService = (KnowledgeBaseFactoryService)registry.get(KnowledgeBaseFactoryService.class);
        ResourceFactoryService resourceFactoryService = (ResourceFactoryService)registry.get(ResourceFactoryService.class);
        KnowledgeBaseConfiguration kbaseConf = knowledgeBaseFactoryService.newKnowledgeBaseConfiguration(null, new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()});
        System.out.println("test dtables started");
        KnowledgeBuilderConfiguration kbConf = knowledgeBuilderFactoryService.newKnowledgeBuilderConfiguration(null, new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()});
        KnowledgeBuilder kbuilder = knowledgeBuilderFactoryService.newKnowledgeBuilder(kbConf);
        kbuilder.add(resourceFactoryService.newClassPathResource("changeset1Test.xml", Dummy.class), ResourceType.CHANGE_SET);
        kbaseConf = knowledgeBaseFactoryService.newKnowledgeBaseConfiguration(null, new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()});
        KnowledgeBase kbase = knowledgeBaseFactoryService.newKnowledgeBase(kbaseConf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ksession.fireAllRules();
        ksession.dispose();
        SimpleOsgiTest.assertEquals((int)3, (int)list.size());
        SimpleOsgiTest.assertEquals((Object)"Young man cheddar", list.get(0));
        SimpleOsgiTest.assertEquals((Object)"rule1", list.get(1));
        SimpleOsgiTest.assertEquals((Object)"rule2", list.get(2));
        System.out.println("test dtables ended");
    }
}

