/*
 * Decompiled with CFR 0.152.
 */
package org.drools.osgi.test.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;
import org.drools.osgi.test.utils.UnpackedOSGiBundleResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseArtifactFinder {
    private static final Logger log = Logger.getLogger(EclipseArtifactFinder.class);
    private static final String s_PROP_WORKSPACE_AREA = "eclipse.workspace.area";
    private static final String s_PROP_TARGET_AREA = "eclipse.target.area";
    private Set<Plugin> m_WorkspacePlugins = new HashSet<Plugin>();
    private Set<Plugin> m_TargetPlugins = new HashSet<Plugin>();
    private static final String FILE_SCHEME = "file:///";
    private static final String REFERENCE_PROTOCOL = "reference";
    private final FileFilter m_DirectoryFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private final FileFilter m_JARFileFilter = new FileFilter(){

        public boolean accept(File file) {
            String fileExtension = this.getExtension(file.getName());
            return file.isFile() && "jar".equals(fileExtension);
        }

        private String getExtension(String fileName) {
            int dotPlace = fileName.lastIndexOf(46);
            String ext = dotPlace >= 0 ? fileName.substring(dotPlace + 1) : "";
            return ext;
        }
    };
    private final FileFilter m_ManifestDirectoryFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() && "META-INF".equalsIgnoreCase(file.getName());
        }
    };
    private FilenameFilter m_ManifestFilter = new FilenameFilter(){

        public boolean accept(File file, String aName) {
            return "MANIFEST.MF".equals(aName);
        }
    };

    public Resource findArtifact(String aArtifactId, String aVersion) throws IOException {
        File folder;
        if (this.m_WorkspacePlugins.isEmpty() && (folder = this.getEclipseWorkspace()) != null) {
            this.importPluginFromFolder(folder, this.m_WorkspacePlugins);
        }
        if (this.m_TargetPlugins.isEmpty()) {
            File[] folders;
            for (File folder2 : folders = this.getEclipseTarget()) {
                this.importPluginFromFolder(folder2, this.m_TargetPlugins);
            }
        }
        for (Plugin plugin : this.m_WorkspacePlugins) {
            if (!plugin.match(aArtifactId, aVersion)) continue;
            if (plugin.isExploded()) {
                return this.getExplodedPluginResource(plugin);
            }
            return this.getJARPluginResource(plugin);
        }
        for (Plugin plugin : this.m_TargetPlugins) {
            if (!plugin.match(aArtifactId, aVersion)) continue;
            if (plugin.isExploded()) {
                return this.getExplodedPluginResource(plugin);
            }
            return this.getJARPluginResource(plugin);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void importPluginFromFolder(File folder, Set<Plugin> plugins) throws IOException {
        void var6_10;
        log.info((Object)("Importing plugins from folder " + folder.getAbsolutePath()));
        HashSet<FileSystemResource> eclipseProjects = new HashSet<FileSystemResource>();
        File[] arr$ = folder.listFiles(this.m_DirectoryFilter);
        int n = arr$.length;
        boolean bl = false;
        while (var6_10 < n) {
            File projectFolder = arr$[var6_10];
            eclipseProjects.add(new FileSystemResource(projectFolder));
            ++var6_10;
        }
        for (Resource resource : eclipseProjects) {
            Manifest manifest = this.getManifestFromProject(resource);
            if (manifest != null) {
                this.addPlugin(plugins, resource, manifest, true);
                continue;
            }
            List<String> list = Arrays.asList(((FileSystemResource)resource).getFile().list());
            for (String str : list) {
                if (!str.contains("drools-eclipse") && !str.contains("osgi-bundles")) continue;
                list = null;
            }
            if (list == null || !list.contains("pom.xml")) continue;
            this.importPluginFromFolder(((FileSystemResource)resource).getFile(), plugins);
        }
        HashSet<FileSystemResource> packagedBundles = new HashSet<FileSystemResource>();
        for (File jarFile : folder.listFiles(this.m_JARFileFilter)) {
            packagedBundles.add(new FileSystemResource(jarFile));
        }
        for (Resource resource : packagedBundles) {
            Manifest man = this.getManifestFromJAR(resource);
            if (man == null) continue;
            this.addPlugin(plugins, resource, man, false);
        }
    }

    private void addPlugin(Set<Plugin> plugins, Resource resource, Manifest man, boolean isExploded) {
        Attributes attrs = man.getMainAttributes();
        String symbolicName = attrs.getValue("Bundle-SymbolicName");
        if (symbolicName != null) {
            symbolicName = symbolicName.replace("singleton:=true", "");
            symbolicName = symbolicName.trim().replace(";", "");
            String version = attrs.getValue("Bundle-Version");
            if (symbolicName != null && version != null) {
                plugins.add(new Plugin(symbolicName, version, resource, isExploded));
            }
        }
    }

    private Resource getJARPluginResource(Plugin aPlugin) throws IOException {
        return new FileSystemResource(aPlugin.getPath().getFile());
    }

    private Resource getExplodedPluginResource(Plugin plugin) throws IOException {
        URL url = new URL(REFERENCE_PROTOCOL, null, FILE_SCHEME + plugin.getPath().getFile().getCanonicalPath() + File.separator + "target" + File.separator + "classes");
        return new UnpackedOSGiBundleResource(url);
    }

    private Manifest getManifestFromProject(Resource aResource) throws IOException {
        try {
            File[] arr$ = aResource.getFile().listFiles(this.m_ManifestDirectoryFilter);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i$2 = 0;
                File manifestFolder = arr$[i$];
                File[] arr$2 = manifestFolder.listFiles(this.m_ManifestFilter);
                int len$2 = arr$2.length;
                if (i$2 >= len$2) continue;
                File manifestFile = arr$2[i$2];
                return new Manifest(new FileInputStream(manifestFile));
            }
        }
        catch (IOException aEx) {
            log.error((Object)("Problem reading MANIFEST.MF from resource" + aResource.getFilename()));
            throw aEx;
        }
        return null;
    }

    private Manifest getManifestFromJAR(Resource aResource) throws IOException {
        JarFile jar = new JarFile(aResource.getFile());
        return jar.getManifest();
    }

    private File getEclipseWorkspace() {
        String workspaceAreaProp = System.getProperty(s_PROP_WORKSPACE_AREA, "../..");
        try {
            System.out.println("workspace area: " + new File(workspaceAreaProp).getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to set path");
        }
        if (workspaceAreaProp != null) {
            return new File(workspaceAreaProp);
        }
        return null;
    }

    private File[] getEclipseTarget() {
        ArrayList<File> result = new ArrayList<File>();
        Properties props = System.getProperties();
        for (String string : props.keySet()) {
            if (!string.startsWith(s_PROP_TARGET_AREA)) continue;
            System.out.println("target area: " + System.getProperty(string));
            File f = new File(System.getProperty(string));
            if (!f.isDirectory()) {
                throw new IllegalStateException("eclipse.target.area not set.");
            }
            result.add(f);
        }
        if (result.isEmpty()) {
            File f = new File("../plugins");
            if (!f.isDirectory()) {
                throw new IllegalStateException("eclipse.target.area not set.");
            }
            result.add(f);
        }
        if (result.size() == 0) {
            throw new IllegalStateException("eclipse.target.area not set.");
        }
        return result.toArray(new File[0]);
    }

    private class Plugin {
        private String m_BundleSymbolicName;
        private String m_BundleVersion;
        private Resource m_Path;
        private boolean m_IsExploded;

        public Plugin(String aBundleSymbolicName, String aVersion, Resource aPath, boolean isExploded) {
            this.m_BundleSymbolicName = aBundleSymbolicName;
            this.m_BundleVersion = aVersion;
            this.m_Path = aPath;
            this.m_IsExploded = isExploded;
        }

        public boolean isExploded() {
            return this.m_IsExploded;
        }

        public boolean match(String artifactId, String version) {
            return this.m_BundleSymbolicName.equals(artifactId) && this.m_BundleVersion.startsWith(version);
        }

        public String getBundleSymbolicName() {
            return this.m_BundleSymbolicName;
        }

        public void setBundleSymbolicName(String aBundleSymbolicName) {
            this.m_BundleSymbolicName = aBundleSymbolicName;
        }

        public String getBundleVersion() {
            return this.m_BundleVersion;
        }

        public void setBundleVersion(String aBundleVersion) {
            this.m_BundleVersion = aBundleVersion;
        }

        public Resource getPath() {
            return this.m_Path;
        }

        public void setPath(Resource aPath) {
            this.m_Path = aPath;
        }

        public boolean equals(Object aOther) {
            if (!(aOther instanceof Plugin)) {
                return false;
            }
            if (this == aOther) {
                return true;
            }
            Plugin rhs = (Plugin)aOther;
            return this.m_BundleSymbolicName.equals(rhs.getBundleSymbolicName()) && this.m_BundleVersion.equals(rhs.getBundleVersion()) && this.m_Path.equals(rhs.getPath());
        }

        public int hashCode() {
            return this.m_BundleSymbolicName.hashCode() + this.m_BundleVersion.hashCode() + this.m_Path.hashCode();
        }

        public String toString() {
            return this.m_BundleSymbolicName + " " + this.m_BundleVersion;
        }
    }
}

