/*
 * Decompiled with CFR 0.152.
 */
package org.drools.osgi.test.utils;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.drools.osgi.test.utils.EclipseArtifactFinder;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.provisioning.ArtifactLocator;

public class EclipseWorkspaceArtifactLocator
implements ArtifactLocator {
    private static final Logger log = Logger.getLogger(EclipseWorkspaceArtifactLocator.class);
    private EclipseArtifactFinder m_ArtifactFinder = new EclipseArtifactFinder();

    public Resource locateArtifact(String groupId, String artifactId, String version) {
        return this.locateArtifact(groupId, artifactId, version, "jar");
    }

    public Resource locateArtifact(String groupId, String artifactId, String version, String type) {
        return this.localEclipseWorkspaceArtifact(artifactId, version);
    }

    private Resource localEclipseWorkspaceArtifact(String aArtifactId, String aVersion) {
        try {
            Resource res = this.m_ArtifactFinder.findArtifact(aArtifactId, aVersion);
            if (res != null && log.isDebugEnabled()) {
                log.debug((Object)("[" + aArtifactId + "|" + aVersion + "] resolved to " + res.getDescription() + " as a Eclipse artifact"));
            }
            return res;
        }
        catch (IOException ioEx) {
            throw (RuntimeException)new IllegalStateException("Artifact " + aArtifactId + "-" + aVersion + " could not be found").initCause(ioEx);
        }
    }
}

