/*
 * Decompiled with CFR 0.152.
 */
package org.drools.osgi.test.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.springframework.core.io.UrlResource;

public class UnpackedOSGiBundleResource
extends UrlResource {
    public UnpackedOSGiBundleResource(URL aUrl) {
        super(aUrl);
        File file = new File(aUrl.getPath().substring("file:///".length()));
        File targetMetaInfDir = new File(file, "META-INF");
        targetMetaInfDir.mkdir();
        File targetMetaInf = new File(targetMetaInfDir, "MANIFEST.MF");
        File sourceMetaInfDir = new File(new File(new File(file.getParent()).getParent()), "META-INF");
        File sourceMetaInf = new File(sourceMetaInfDir, "MANIFEST.MF");
        this.copyfile(sourceMetaInf, targetMetaInf);
        File sourceBuildProperties = new File(new File(file.getParent()).getParent(), "build.properties");
        File targetBuildProperties = new File(file, "build.properties");
        this.copyfile(sourceBuildProperties, targetBuildProperties);
    }

    public InputStream getInputStream() throws IOException {
        return super.getURL().openStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyfile(File f1, File f2) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(f1);
            out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            return;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Unable to copy file from '" + f1.getAbsolutePath() + " to " + f2.getAbsolutePath(), ex);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy file from '" + f1.getAbsolutePath() + " to " + f2.getAbsolutePath(), e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close Input stream", e);
                }
                finally {
                    if (out != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Unable to close Input stream", e);
                        }
                    }
                }
            }
        }
    }
}

