/*
 * Decompiled with CFR 0.152.
 */
package org.drools.osgi.test;

import org.drools.osgi.test.utils.EclipseWorkspaceArtifactLocator;
import org.osgi.framework.BundleContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.AbstractConfigurableBundleCreatorTests;
import org.springframework.osgi.test.platform.OsgiPlatform;
import org.springframework.osgi.test.provisioning.ArtifactLocator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractDroolsSpringDMTest
extends AbstractConfigurableBundleCreatorTests {
    private static final String TEST_FRAMEWORK_BUNDLES_CONF_FILE = "/boot-bundles.properties";
    private ArtifactLocator m_MavenArtifactLocator;
    private ArtifactLocator m_EclipseArtifactLocator;

    protected boolean createManifestOnlyFromTestClass() {
        return false;
    }

    protected void preProcessBundleContext(BundleContext platformBundleContext) throws Exception {
        super.preProcessBundleContext(platformBundleContext);
    }

    protected void postProcessBundleContext(BundleContext context) throws Exception {
        super.postProcessBundleContext(context);
    }

    protected OsgiPlatform createPlatform() {
        System.setProperty("osgi.console", "9000");
        System.setProperty("osgi.framework.extensions", "osgi.framework.extensions");
        return super.createPlatform();
    }

    protected Resource getTestingFrameworkBundlesConfiguration() {
        return new InputStreamResource(AbstractDroolsSpringDMTest.class.getResourceAsStream(TEST_FRAMEWORK_BUNDLES_CONF_FILE));
    }

    protected Resource locateBundle(String bundleId) {
        Assert.hasText((String)bundleId, (String)"bundleId should not be empty");
        Resource result = null;
        String[] artifactId = StringUtils.commaDelimitedListToStringArray((String)bundleId);
        Assert.isTrue((artifactId.length >= 3 ? 1 : 0) != 0, (String)("the CSV string " + bundleId + " contains too few values"));
        for (int i = 0; i < artifactId.length; ++i) {
            artifactId[i] = StringUtils.trimWhitespace((String)artifactId[i]);
        }
        if (this.m_EclipseArtifactLocator == null) {
            this.m_EclipseArtifactLocator = new EclipseWorkspaceArtifactLocator();
        }
        Resource resource = result = artifactId.length == 3 ? this.m_EclipseArtifactLocator.locateArtifact(artifactId[0], artifactId[1], artifactId[2]) : this.m_EclipseArtifactLocator.locateArtifact(artifactId[0], artifactId[1], artifactId[2], artifactId[3]);
        if (result == null) {
            if (this.m_MavenArtifactLocator == null) {
                this.m_MavenArtifactLocator = this.getLocator();
            }
            Resource resource2 = result = artifactId.length == 3 ? this.m_MavenArtifactLocator.locateArtifact(artifactId[0], artifactId[1], artifactId[2]) : this.m_MavenArtifactLocator.locateArtifact(artifactId[0], artifactId[1], artifactId[2], artifactId[3]);
        }
        if (result == null) {
            throw new IllegalStateException(bundleId + " not found");
        }
        return result;
    }
}

