/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class DroolsLineBreakpointMarkerUpdater
implements IMarkerUpdater {
    private static final String[] ATTRIBUTES = new String[]{"lineNumber", "Drools_DRL_LineNumber"};

    public String getMarkerType() {
        return "org.drools.eclipse.droolsBreakpointMarker";
    }

    public String[] getAttribute() {
        return ATTRIBUTES;
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        if (position == null) {
            return true;
        }
        if (position.isDeleted()) {
            return false;
        }
        boolean offsetsInitialized = false;
        boolean offsetsChanged = false;
        int markerStart = MarkerUtilities.getCharStart((IMarker)marker);
        int markerEnd = MarkerUtilities.getCharEnd((IMarker)marker);
        if (markerStart != -1 && markerEnd != -1) {
            offsetsInitialized = true;
            int offset = position.getOffset();
            if (markerStart != offset) {
                MarkerUtilities.setCharStart((IMarker)marker, (int)offset);
                offsetsChanged = true;
            }
            if (markerEnd != (offset += position.getLength())) {
                MarkerUtilities.setCharEnd((IMarker)marker, (int)offset);
                offsetsChanged = true;
            }
        }
        if (!offsetsInitialized || offsetsChanged && MarkerUtilities.getLineNumber((IMarker)marker) != -1) {
            try {
                int drlLineNumber = document.getLineOfOffset(position.getOffset()) + 1;
                marker.setAttribute("Drools_DRL_LineNumber", drlLineNumber);
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
            }
        }
        return true;
    }
}

