/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart.work;

import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.process.core.Work;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.WorkEditor;
import org.drools.process.core.impl.WorkImpl;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskCustomEditor
extends EditBeanDialog<Work>
implements WorkEditor {
    private Text nameText;
    private Text actorText;
    private Text groupText;
    private Text commentText;
    private Text priorityText;
    private Button skippableButton;
    private Text contentText;

    public HumanTaskCustomEditor(Shell parentShell) {
        super(parentShell, "Human Task Editor");
        this.setBlockOnOpen(true);
    }

    @Override
    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Work work = (Work)this.getValue();
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name: ");
        this.nameText = new Text(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameText.setLayoutData((Object)gridData);
        String name = (String)work.getParameter("TaskName");
        this.nameText.setText(name == null ? "" : name);
        Label label = new Label(composite, 0);
        label.setText("Actor(s): ");
        this.actorText = new Text(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.actorText.setLayoutData((Object)gridData);
        String value = (String)work.getParameter("ActorId");
        this.actorText.setText(value == null ? "" : value);
        label = new Label(composite, 0);
        label.setText("Group(s): ");
        this.groupText = new Text(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.groupText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("GroupId");
        this.groupText.setText(value == null ? "" : value);
        label = new Label(composite, 0);
        label.setText("Comment: ");
        this.commentText = new Text(composite, 2);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.commentText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("Comment");
        this.commentText.setText(value == null ? "" : value.toString());
        label = new Label(composite, 0);
        label.setText("Priority: ");
        this.priorityText = new Text(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.priorityText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("Priority");
        this.priorityText.setText(value == null ? "" : value);
        this.skippableButton = new Button(composite, 16416);
        this.skippableButton.setText("Skippable");
        value = (String)work.getParameter("Skippable");
        this.skippableButton.setSelection("true".equals(value));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.skippableButton.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Content: ");
        this.contentText = new Text(composite, 2);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.contentText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("Content");
        this.contentText.setText(value == null ? "" : value.toString());
        return composite;
    }

    @Override
    protected Work updateValue(Work value) {
        WorkImpl work = new WorkImpl();
        work.setName("Human Task");
        work.setParameter("TaskName", (Object)this.nameText.getText());
        work.setParameter("ActorId", (Object)this.actorText.getText());
        work.setParameter("GroupId", (Object)this.groupText.getText());
        work.setParameter("Comment", (Object)this.commentText.getText());
        work.setParameter("Priority", (Object)this.priorityText.getText());
        work.setParameter("Skippable", (Object)String.valueOf(this.skippableButton.getSelection()));
        String content = this.contentText.getText();
        work.setParameter("Content", (Object)(content.trim().length() == 0 ? null : content));
        work.setParameterDefinitions(value.getParameterDefinitions());
        return work;
    }

    public Work getWork() {
        return (Work)this.getValue();
    }

    public void setWork(Work work) {
        this.setValue(work);
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
    }

    public boolean show() {
        int result = this.open();
        return result == 0;
    }
}

