/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.DroolsDebugEventHandlerView;
import org.drools.eclipse.debug.ProcessInstanceViewer;
import org.drools.eclipse.debug.ProcessInstancesViewContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;

public class ProcessInstancesView
extends DroolsDebugEventHandlerView {
    public ProcessInstancesView() {
        this.setAction("Double_Click_ActionId", (IAction)new DoubleClickAction());
    }

    @Override
    protected IContentProvider createContentProvider() {
        ProcessInstancesViewContentProvider contentProvider = new ProcessInstancesViewContentProvider(this);
        return contentProvider;
    }

    private class DoubleClickAction
    extends Action {
        private DoubleClickAction() {
        }

        public void run() {
            Object selected;
            ISelection selection;
            IViewPart view = ProcessInstancesView.this.getSite().getPage().findView("org.drools.eclipse.debug.ProcessInstanceViewer");
            if (view == null) {
                try {
                    view = ProcessInstancesView.this.getSite().getPage().showView("org.drools.eclipse.debug.ProcessInstanceViewer");
                }
                catch (PartInitException e) {
                    DroolsEclipsePlugin.log(e);
                }
            }
            if (view != null && (selection = ProcessInstancesView.this.getViewer().getSelection()) instanceof StructuredSelection && (selected = ((StructuredSelection)selection).getFirstElement()) instanceof IJavaVariable) {
                try {
                    this.openProcessInstance(((IJavaVariable)selected).getValue(), view);
                }
                catch (DebugException e) {
                    DroolsEclipsePlugin.log(e);
                }
            }
        }

        private void openProcessInstance(IValue processInstance, IViewPart view) throws DebugException {
            String id = null;
            String processId = null;
            IVariable[] vars = processInstance.getVariables();
            int j = 0;
            while (j < vars.length) {
                IVariable var = vars[j];
                if ("id".equals(var.getName())) {
                    id = ((IJavaValue)var.getValue()).getValueString();
                } else if ("process".equals(var.getName())) {
                    IJavaValue process = (IJavaValue)var.getValue();
                    IVariable[] vars2 = process.getVariables();
                    int k = 0;
                    while (k < vars2.length) {
                        IVariable var2 = vars2[k];
                        if ("id".equals(var2.getName())) {
                            processId = ((IJavaValue)var2.getValue()).getValueString();
                            break;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ArrayList<String> nodeIds = new ArrayList<String>();
            IJavaArray nodeInstances = (IJavaArray)DebugUtil.getValueByExpression("return getNodeInstances().toArray();", processInstance);
            IJavaValue[] javaVals = nodeInstances.getValues();
            int i = 0;
            while (i < javaVals.length) {
                IJavaValue nodeInstance = javaVals[i];
                String nodeId = null;
                vars = nodeInstance.getVariables();
                int j2 = 0;
                while (j2 < vars.length) {
                    IVariable var = vars[j2];
                    if ("nodeId".equals(var.getName())) {
                        nodeId = ((IJavaValue)var.getValue()).getValueString();
                        break;
                    }
                    ++j2;
                }
                nodeIds.add(nodeId);
                ++i;
            }
            String projectName = null;
            try {
                projectName = processInstance.getLaunch().getLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            }
            catch (CoreException e) {
                DroolsEclipsePlugin.log(e);
            }
            ((ProcessInstanceViewer)view).showProcessInstance(id, processId, nodeIds, projectName);
        }
    }
}

