/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.List;
import java.util.Map;
import org.drools.core.util.ArrayUtils;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.ConstraintCompletionProcessor;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowGlobalsDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowImportsDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.ConstraintImpl;

public class RuleFlowConstraintDialog
extends Dialog {
    private static final String[] DIALECTS = new String[]{"mvel", "java"};
    private static final String[] TYPES = new String[]{"rule", "code"};
    private Constraint constraint;
    private WorkflowProcess process;
    private boolean success;
    private Button alwaysTrue;
    private Text nameText;
    private Text priorityText;
    private Combo typeCombo;
    private Combo dialectCombo;
    private TabFolder tabFolder;
    private SourceViewer constraintViewer;
    private ConstraintCompletionProcessor completionProcessor;

    public RuleFlowConstraintDialog(Shell parentShell, WorkflowProcess process) {
        super(parentShell);
        this.process = process;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Constraint editor");
    }

    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite parent) {
        this.constraintViewer = new SourceViewer(parent, null, 2048);
        this.constraintViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            @Override
            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                return null;
            }

            @Override
            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                RuleFlowConstraintDialog.this.completionProcessor = new ConstraintCompletionProcessor(RuleFlowConstraintDialog.this.process);
                assistant.setContentAssistProcessor((IContentAssistProcessor)RuleFlowConstraintDialog.this.completionProcessor, "__dftl_partition_content_type");
                assistant.setProposalPopupOrientation(10);
                return assistant;
            }
        });
        Document document = new Document();
        this.constraintViewer.setDocument((IDocument)document);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.constraintViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' && e.stateMask == 262144) {
                    RuleFlowConstraintDialog.this.constraintViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.constraintViewer.getControl();
    }

    private String getConstraintText() {
        return this.constraintViewer.getDocument().get();
    }

    private void setConstraintText(String text) {
        this.constraintViewer.getDocument().set(text);
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 2;
        Composite top = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        top.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 4;
        top.setLayout((Layout)layout);
        Label l1 = new Label(top, 0);
        l1.setText("Name:");
        gd = new GridData();
        l1.setLayoutData((Object)gd);
        this.nameText = new Text(top, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 200;
        gd.horizontalSpan = 3;
        this.nameText.setLayoutData((Object)gd);
        Label l2 = new Label(top, 0);
        gd = new GridData();
        l2.setLayoutData((Object)gd);
        l2.setText("Priority:");
        this.priorityText = new Text(top, 2048);
        gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalSpan = 3;
        this.priorityText.setLayoutData((Object)gd);
        this.alwaysTrue = new Button(top, 32);
        this.alwaysTrue.setText("Always true");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.alwaysTrue.setLayoutData((Object)gd);
        Button importButton = new Button(top, 8);
        importButton.setText("Imports ...");
        importButton.setFont(JFaceResources.getDialogFont());
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleFlowConstraintDialog.this.importButtonPressed();
            }
        });
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 3;
        importButton.setLayoutData((Object)gd);
        Button globalButton = new Button(top, 8);
        globalButton.setText("Globals ...");
        globalButton.setFont(JFaceResources.getDialogFont());
        globalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleFlowConstraintDialog.this.globalButtonPressed();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 3;
        globalButton.setLayoutData((Object)gd);
        Label l3 = new Label(top, 0);
        gd = new GridData();
        l3.setLayoutData((Object)gd);
        l3.setText("Type:");
        this.typeCombo = new Combo(top, 12);
        this.typeCombo.setItems(TYPES);
        gd = new GridData();
        this.typeCombo.setLayoutData((Object)gd);
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (RuleFlowConstraintDialog.this.completionProcessor != null) {
                    RuleFlowConstraintDialog.this.completionProcessor.setType(RuleFlowConstraintDialog.this.typeCombo.getText());
                }
            }
        });
        this.typeCombo.select(0);
        Label l4 = new Label(top, 0);
        gd = new GridData();
        l4.setLayoutData((Object)gd);
        l4.setText("Dialect:");
        this.dialectCombo = new Combo(top, 12);
        this.dialectCombo.setItems(DIALECTS);
        this.dialectCombo.select(0);
        gd = new GridData();
        this.dialectCombo.setLayoutData((Object)gd);
        this.tabFolder = new TabFolder(parent, 0);
        gd = new GridData();
        gd.horizontalSpan = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gd);
        TabItem textEditorTab = new TabItem(this.tabFolder, 0);
        textEditorTab.setText("Textual Editor");
        textEditorTab.setControl(this.createTextualEditor((Composite)this.tabFolder));
        this.alwaysTrue.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RuleFlowConstraintDialog.this.tabFolder.setVisible(!RuleFlowConstraintDialog.this.alwaysTrue.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return this.tabFolder;
    }

    private void importButtonPressed() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RuleFlowImportsDialog dialog = new RuleFlowImportsDialog(RuleFlowConstraintDialog.this.getShell(), RuleFlowConstraintDialog.this.process);
                dialog.create();
                int code = dialog.open();
                if (code != 1) {
                    List<String> imports = dialog.getImports();
                    RuleFlowConstraintDialog.this.process.setImports(imports);
                    RuleFlowConstraintDialog.this.completionProcessor.reset();
                }
            }
        };
        r.run();
    }

    private void globalButtonPressed() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RuleFlowGlobalsDialog dialog = new RuleFlowGlobalsDialog(RuleFlowConstraintDialog.this.getShell(), RuleFlowConstraintDialog.this.process);
                dialog.create();
                int code = dialog.open();
                if (code != 1) {
                    Map<String, String> globals = dialog.getGlobals();
                    RuleFlowConstraintDialog.this.process.setGlobals(globals);
                    RuleFlowConstraintDialog.this.completionProcessor.reset();
                }
            }
        };
        r.run();
    }

    public void fixType(int index) {
        this.typeCombo.select(index);
        this.typeCombo.setEnabled(false);
    }

    public void fixDialect(int index) {
        this.typeCombo.select(index);
        this.typeCombo.setEnabled(false);
    }

    protected void okPressed() {
        int selectionIndex = this.tabFolder.getSelectionIndex();
        if (selectionIndex == 1) {
            this.updateTranslation();
        } else {
            this.updateConstraint();
        }
        super.okPressed();
    }

    private void updateTranslation() {
        this.success = true;
        this.constraint = new ConstraintImpl();
        this.constraint.setConstraint(null);
        this.constraint.setConstraint(this.getConstraintText());
        this.constraint.setName(this.nameText.getText());
        try {
            this.constraint.setPriority(Integer.parseInt(this.priorityText.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            this.constraint.setPriority(1);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void updateConstraint() {
        this.constraint = new ConstraintImpl();
        if (!this.alwaysTrue.getSelection()) {
            this.constraint.setConstraint(this.getConstraintText());
        } else if (this.typeCombo.getSelectionIndex() == 0) {
            this.constraint.setConstraint("eval(true)");
        } else {
            this.constraint.setConstraint("return true;");
        }
        this.constraint.setName(this.nameText.getText());
        try {
            this.constraint.setPriority(Integer.parseInt(this.priorityText.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            this.constraint.setPriority(1);
        }
        this.constraint.setType(this.typeCombo.getItem(this.typeCombo.getSelectionIndex()));
        this.constraint.setDialect(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()));
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
        if (constraint != null) {
            if ("eval(true)".equals(constraint.getConstraint()) || "return true;".equals(constraint.getConstraint())) {
                this.alwaysTrue.setSelection(true);
            } else {
                this.setConstraintText(constraint.getConstraint() == null ? "" : constraint.getConstraint());
            }
            this.tabFolder.setVisible(!this.alwaysTrue.getSelection());
            this.nameText.setText(constraint.getName() == null ? "" : constraint.getName());
            this.priorityText.setText(String.valueOf(constraint.getPriority()));
            int index = 0;
            String type = constraint.getType();
            int found = ArrayUtils.indexOf((Object[])TYPES, (Object)type);
            if (found >= 0) {
                index = found;
            }
            this.typeCombo.select(index);
            index = 0;
            String dialect = constraint.getDialect();
            found = ArrayUtils.indexOf((Object[])DIALECTS, (Object)dialect);
            if (found >= 0) {
                index = found;
            }
            this.dialectCombo.select(index);
            this.completionProcessor.setType(this.typeCombo.getText());
            this.setConstraintText(constraint.getConstraint());
        } else {
            this.priorityText.setText("1");
            this.nameText.setText("constraint");
        }
    }
}

