/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.QualifiedName;

public class QualifiedNameImpl
implements QualifiedName {
    protected String qualifier = null;
    protected String localName = null;

    public QualifiedNameImpl(String qualifier, String localName) {
        Assert.isTrue(localName != null && localName.length() != 0);
        this.qualifier = qualifier;
        this.localName = localName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QualifiedName)) {
            return false;
        }
        QualifiedName qName = (QualifiedName)obj;
        if (this.qualifier == null && qName.getQualifier() != null) {
            return false;
        }
        if (this.qualifier != null && !this.qualifier.equals(qName.getQualifier())) {
            return false;
        }
        return this.localName.equals(qName.getLocalName());
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    public int hashCode() {
        return (this.qualifier == null ? 0 : this.qualifier.hashCode()) + this.localName.hashCode();
    }

    public String toString() {
        return String.valueOf(Policy.bind("qualifiedNameImpl.namespace")) + ": \"" + (this.getQualifier() == null ? "null" : this.getQualifier()) + "\", " + Policy.bind("qualifiedNameImpl.localPart") + ": \"" + this.getLocalName() + "\"";
    }
}

