/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete.part;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.drools.eclipse.editors.rete.figure.VertexFigure;
import org.drools.eclipse.editors.rete.model.Connection;
import org.drools.eclipse.editors.rete.model.ModelElement;
import org.drools.eclipse.editors.rete.model.VertexPropertySource;
import org.drools.eclipse.reteoo.BaseVertex;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.ui.views.properties.IPropertySource;

class VertexEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    private IPropertySource propertySource;
    private ConnectionAnchor anchor;

    VertexEditPart() {
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
            this.propertySource = new VertexPropertySource(this.getCastedModel());
        }
    }

    protected void createEditPolicies() {
    }

    protected IFigure createFigure() {
        return new VertexFigure(this.getCastedModel().getFillColor(), this.getCastedModel().getDrawColor());
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
            this.propertySource = null;
        }
    }

    private BaseVertex getCastedModel() {
        return (BaseVertex)this.getModel();
    }

    private ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            if (this.getModel() instanceof BaseVertex) {
                this.anchor = new EllipseAnchor(this.getFigure());
            } else {
                throw new IllegalArgumentException("unexpected model");
            }
        }
        return this.anchor;
    }

    protected List<Connection> getModelSourceConnections() {
        return this.getCastedModel().getSourceConnections();
    }

    protected List<Connection> getModelTargetConnections() {
        return this.getCastedModel().getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("BaseVertex .Size".equals(prop) || "BaseVertex .Location".equals(prop)) {
            this.refreshVisuals();
        } else if ("BaseVertex .SourceConn".equals(prop)) {
            this.refreshSourceConnections();
        } else if ("BaseVertex .TargetConn".equals(prop)) {
            this.refreshTargetConnections();
        }
    }

    protected void refreshVisuals() {
        Rectangle bounds = new Rectangle(this.getCastedModel().getLocation(), this.getCastedModel().getSize());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
    }

    public Object getAdapter(Class key) {
        if (key == IPropertySource.class) {
            return this.propertySource;
        }
        return super.getAdapter(key);
    }
}

