/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.action;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.jbpm.eclipse.JBPMEclipsePlugin;
import org.jbpm.eclipse.wizard.project.NewJBPMProjectWizard;

public class ConvertToJBPMProjectAction
implements IObjectActionDelegate {
    private IJavaProject project;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.project != null && this.project.exists()) {
            try {
                ConvertToJBPMProjectAction.addJBPMLibraries(this.project, null);
            }
            catch (Throwable t) {
                JBPMEclipsePlugin.log(t);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structured;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            IJavaProject javaProject;
            Object element = structured.getFirstElement();
            if (element instanceof IJavaProject) {
                this.project = (IJavaProject)element;
            } else if (element instanceof IProject && (javaProject = JavaCore.create((IProject)((IProject)element))) != null && javaProject.exists()) {
                this.project = javaProject;
            }
        }
    }

    public static void addJBPMLibraries(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] classpathEntries = project.getRawClasspath();
        int i = 0;
        while (i < classpathEntries.length) {
            if (NewJBPMProjectWizard.JBPM_CLASSPATH_CONTAINER_PATH.equals((Object)classpathEntries[i].getPath().toString())) {
                return;
            }
            ++i;
        }
        NewJBPMProjectWizard.addJBPMLibraries(project, null);
    }
}

