/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.wizard.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jbpm.eclipse.JBPMEclipsePlugin;
import org.jbpm.eclipse.util.JBPMRuntime;
import org.jbpm.eclipse.util.JBPMRuntimeManager;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.utils.FileUtils;
import org.kie.eclipse.wizard.project.AbstractKieEmptyProjectWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieOnlineExampleProjectWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieProjectStartWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieProjectWizard;
import org.kie.eclipse.wizard.project.IKieProjectWizardPage;
import org.kie.eclipse.wizard.project.IKieSampleFilesProjectWizardPage;

public class NewJBPMProjectWizard
extends AbstractKieProjectWizard {
    public static final String DROOLS_BUILDER_ID = "org.drools.eclipse.droolsbuilder";
    private EmptyJBPMProjectWizardPage emptyProjectPage;
    private SampleJBPMProjectWizardPage sampleFilesProjectPage;

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = JBPMEclipsePlugin.getImageDescriptor("icons/jbpm-large.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    protected void createOutputLocation(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IFolder folder = project.getProject().getFolder("bin");
        FileUtils.createFolder((IFolder)folder, (IProgressMonitor)monitor);
        IPath path = folder.getFullPath();
        project.setOutputLocation(path, null);
    }

    protected void setClasspath(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        super.setClasspath(project, monitor);
        if (this.startPage.getInitialProjectContent() == 2 && this.sampleFilesProjectPage.shouldCreateJUnitFile()) {
            FileUtils.addJUnitLibrary((IJavaProject)project, (IProgressMonitor)monitor);
        }
    }

    protected void createInitialContent(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException, JavaModelException, IOException {
        if (this.startPage.getInitialProjectContent() == 2) {
            String exampleType = this.sampleFilesProjectPage.getSampleType();
            this.createProcess(javaProject, monitor, exampleType);
            if (this.sampleFilesProjectPage.shouldCreateJUnitFile()) {
                this.createProcessSampleJUnit(javaProject, exampleType, monitor);
            }
        }
        super.createInitialContent(javaProject, monitor);
    }

    private void createProcess(IJavaProject project, IProgressMonitor monitor, String exampleType) throws CoreException {
        String fileName = "org/jbpm/eclipse/wizard/project/" + exampleType + ".bpmn.template";
        IFolder folder = project.getProject().getFolder("src/main/resources");
        IFile file = folder.getFile("sample.bpmn");
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
        if (!file.exists()) {
            file.create(inputstream, true, monitor);
        } else {
            file.setContents(inputstream, true, false, monitor);
        }
    }

    private void createProcessSampleJUnit(IJavaProject project, String exampleType, IProgressMonitor monitor) throws JavaModelException, IOException {
        String s = "org/jbpm/eclipse/wizard/project/ProcessJUnit-" + exampleType + ".java";
        IRuntime runtime = this.startPage.getRuntime();
        s = runtime.getVersion().startsWith("5") ? String.valueOf(s) + ".v5.template" : String.valueOf(s) + ".template";
        IFolder folder = project.getProject().getFolder("src/main/java");
        IPackageFragmentRoot packageFragmentRoot = project.getPackageFragmentRoot((IResource)folder);
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment("com.sample", true, monitor);
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(s);
        packageFragment.createCompilationUnit("ProcessTest.java", new String(FileUtils.readStream((InputStream)inputstream)), true, monitor);
    }

    protected void createKJarArtifacts(IJavaProject project, IProgressMonitor monitor) {
        try {
            String fileName = "org/jbpm/eclipse/wizard/project/kmodule.xml.template";
            IFolder folder = project.getProject().getFolder("src/main/resources/META-INF");
            FileUtils.createFolder((IFolder)folder, (IProgressMonitor)monitor);
            IFile file = folder.getFile("kmodule.xml");
            InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
            if (!file.exists()) {
                file.create(inputstream, true, monitor);
            } else {
                file.setContents(inputstream, true, false, monitor);
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    protected void createMavenArtifacts(IJavaProject project, IProgressMonitor monitor) {
        try {
            String fileName = "org/jbpm/eclipse/wizard/project/maven-pom.xml.template";
            IFile file = project.getProject().getFile("pom.xml");
            InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
            if (!file.exists()) {
                file.create(inputstream, true, monitor);
            } else {
                file.setContents(inputstream, true, false, monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected IKieProjectWizardPage createStartPage(String pageId) {
        return new AbstractKieProjectStartWizardPage(pageId){

            public String getTitle() {
                return "Create New jBPM Project";
            }
        };
    }

    protected IKieProjectWizardPage createEmptyProjectPage(String pageId) {
        this.emptyProjectPage = new EmptyJBPMProjectWizardPage("NewEmptProjectPage");
        return this.emptyProjectPage;
    }

    protected IKieProjectWizardPage createSampleFilesProjectPage(String pageId) {
        this.sampleFilesProjectPage = new SampleJBPMProjectWizardPage("NewSampleFilesProjectPage");
        return this.sampleFilesProjectPage;
    }

    protected IKieProjectWizardPage createOnlineExampleProjectPage(String pageId) {
        return new AbstractKieOnlineExampleProjectWizardPage("NewOnlineExampleProjectPage"){

            public String getTitle() {
                return "Create jBPM Projects from Online Examples";
            }

            public String getDescription() {
                return "Select jBPM Example Projects";
            }

            public String getProductId() {
                return "jbpm";
            }
        };
    }

    class EmptyJBPMProjectWizardPage
    extends AbstractKieEmptyProjectWizardPage
    implements IKieSampleFilesProjectWizardPage {
        public EmptyJBPMProjectWizardPage(String pageName) {
            super(pageName);
            this.setTitle("Create New Empty Drools Project");
            this.setDescription("Select the type of Drools Project");
        }

        protected void createControls(Composite parent) {
        }

        public IRuntimeManager getRuntimeManager() {
            return JBPMRuntimeManager.getDefault();
        }

        protected IRuntime createRuntime() {
            return new JBPMRuntime();
        }

        public int showRuntimePreferenceDialog() {
            return PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.jbpm.eclipse.preferences.JBPMRuntimesPreferencePage", (String[])new String[]{"org.jbpm.eclipse.preferences.JBPMProjectPreferencePage"}, new HashMap()).open();
        }
    }

    class SampleJBPMProjectWizardPage
    extends EmptyJBPMProjectWizardPage {
        private Button simpleProcessButton;
        private Button advancedProcessButton;
        private Button addSampleJUnitTestCodeButton;
        private boolean addSampleJUnit;
        private String sampleType;

        public SampleJBPMProjectWizardPage(String pageName) {
            super(pageName);
            this.addSampleJUnit = true;
            this.sampleType = "simple";
            this.setTitle("Create New jBPM Projects with Sample Files");
            this.setDescription("Select the samples to be included");
        }

        @Override
        protected void createControls(Composite parent) {
            Label label = new Label(parent, 16384);
            label.setText("I want to create:");
            this.simpleProcessButton = this.createRadioButton(parent, "a simple hello world process");
            this.simpleProcessButton.setSelection(true);
            this.simpleProcessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        SampleJBPMProjectWizardPage.this.sampleType = "simple";
                    }
                }
            });
            this.advancedProcessButton = this.createRadioButton(parent, "a more advanced process including human tasks and persistence");
            this.advancedProcessButton.setSelection(false);
            this.advancedProcessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        SampleJBPMProjectWizardPage.this.sampleType = "advanced";
                    }
                }
            });
            this.addSampleJUnitTestCodeButton = this.createCheckBox(parent, "Also include a sample JUnit test for the process");
            this.addSampleJUnitTestCodeButton.setSelection(this.addSampleJUnit);
            this.addSampleJUnitTestCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SampleJBPMProjectWizardPage.this.addSampleJUnit = ((Button)e.widget).getSelection();
                }
            });
        }

        private Button createCheckBox(Composite group, String label) {
            Button button = new Button(group, 16416);
            button.setText(label);
            GridData data = new GridData();
            data.horizontalIndent = 20;
            button.setLayoutData((Object)data);
            return button;
        }

        private Button createRadioButton(Composite group, String label) {
            Button button = new Button(group, 16400);
            button.setText(label);
            GridData data = new GridData();
            data.horizontalIndent = 40;
            button.setLayoutData((Object)data);
            return button;
        }

        public String getSampleType() {
            return this.sampleType;
        }

        public boolean shouldCreateJUnitFile() {
            return this.addSampleJUnit;
        }
    }
}

