/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.server.core.IServer;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.osgi.service.prefs.Preferences;

public abstract class KieResourceHandler
implements IKieResourceHandler {
    protected static IEclipsePreferences preferences;
    protected IKieResourceHandler parent;
    protected List children;
    protected String name;
    protected JsonObject properties;

    public KieResourceHandler(IKieResourceHandler parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IKieResourceHandler getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IKieResourceHandler parent) {
        this.parent = parent;
    }

    @Override
    public IKieResourceHandler getRoot() {
        if (this.getParent() == null) {
            return this;
        }
        return this.getParent().getRoot();
    }

    @Override
    public Object getResource() {
        return null;
    }

    @Override
    public void setResource(Object resource) {
    }

    @Override
    public IServer getServer() {
        if (this.parent != null) {
            return this.parent.getServer();
        }
        return null;
    }

    @Override
    public String getRuntimeId() {
        if (this.parent != null) {
            return this.parent.getRuntimeId();
        }
        return null;
    }

    @Override
    public IKieServiceDelegate getDelegate() {
        if (this.parent != null) {
            return this.parent.getDelegate();
        }
        return null;
    }

    @Override
    public void dispose() {
        this.children = null;
    }

    @Override
    public Object load() {
        return null;
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    @Override
    public void setProperties(JsonObject properties) {
        JsonValue v = properties.get("name");
        if (v != null && v.isString()) {
            this.name = v.asString();
        }
        this.properties = properties;
    }

    @Override
    public JsonObject getProperties() {
        return this.properties;
    }

    protected static String getCanonicalName(String name) {
        return name.replaceAll("[^A-Za-z0-9_.,]", "_");
    }

    @Override
    public String getPreferenceName(String name) {
        String canonicalName = KieResourceHandler.getCanonicalName(this.getRoot().getName());
        if (name == null) {
            return canonicalName;
        }
        return String.valueOf(canonicalName) + "|" + KieResourceHandler.getCanonicalName(name);
    }

    @Override
    public Preferences getPreferences() {
        if (preferences == null) {
            preferences = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node("org.kie.eclipse");
        }
        return preferences;
    }

    @Override
    public String getPreference(String name, String def) {
        return this.getPreferences().get(this.getPreferenceName(name), def);
    }

    @Override
    public boolean getPreference(String name, boolean def) {
        return this.getPreferences().getBoolean(this.getPreferenceName(name), def);
    }

    @Override
    public int getPreference(String name, int def) {
        return this.getPreferences().getInt(this.getPreferenceName(name), def);
    }

    @Override
    public void putPreference(String name, String value) {
        this.getPreferences().put(this.getPreferenceName(name), value);
    }

    @Override
    public void putPreference(String name, boolean value) {
        this.getPreferences().putBoolean(this.getPreferenceName(name), value);
    }

    @Override
    public void putPreference(String name, int value) {
        this.getPreferences().putInt(this.getPreferenceName(name), value);
    }
}

