/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.project;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieServiceDelegate;

public class DeleteProjectAction
extends KieNavigatorAction {
    public DeleteProjectAction(ISelectionProvider provider) {
        super(provider, "Delete Project...");
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        IKieProjectHandler project = (IKieProjectHandler)container.getHandler();
        IKieServiceDelegate delegate = this.getDelegate();
        boolean doit = MessageDialog.openConfirm((Shell)DeleteProjectAction.getShell(), (String)"Delete Project", (String)("Are you sure you want to delete the Project " + container.getName() + "?"));
        if (doit) {
            try {
                delegate.deleteProject(project);
                container.getParent().clearChildren();
                DeleteProjectAction.refreshViewer(container.getParent());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

