/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import org.eclipse.webdav.internal.kernel.Policy;

public class DAV4JRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 510L;
    private Throwable fWrappedException = null;
    private int fErrorCode = 0;

    public DAV4JRuntimeException(int code, String message) {
        super(message);
        this.setErrorCode(code);
    }

    public DAV4JRuntimeException(String message) {
        super(message);
    }

    public DAV4JRuntimeException(Throwable exception) {
        if (exception instanceof DAV4JRuntimeException) {
            this.setWrappedException(((DAV4JRuntimeException)exception).getWrappedException());
        } else {
            this.setWrappedException(exception);
        }
    }

    public DAV4JRuntimeException(Throwable exception, String message) {
        super(String.valueOf(message) + "\n " + Policy.bind("label.exceptionMessage") + exception.getMessage());
        this.setWrappedException(exception);
    }

    public int getErrorCode() {
        if (this.getWrappedException() != null && this.getWrappedException() instanceof DAV4JRuntimeException) {
            return ((DAV4JRuntimeException)this.getWrappedException()).getErrorCode();
        }
        return this.fErrorCode;
    }

    public Throwable getWrappedException() {
        return this.fWrappedException;
    }

    @Override
    public void printStackTrace() {
        Throwable wrappedException = this.getWrappedException();
        if (wrappedException != null) {
            wrappedException.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    protected void setErrorCode(int errorCode) {
        this.fErrorCode = errorCode;
    }

    protected void setWrappedException(Throwable exception) {
        this.fWrappedException = exception;
    }
}

