/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.organization;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.server.IKieOrganizationHandler;
import org.kie.eclipse.server.IKieServiceDelegate;

public class DeleteOrganizationAction
extends KieNavigatorAction {
    public DeleteOrganizationAction(ISelectionProvider provider) {
        super(provider, "Delete Organization...");
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        IKieOrganizationHandler organization = (IKieOrganizationHandler)container.getHandler();
        IKieServiceDelegate delegate = this.getDelegate();
        boolean doit = MessageDialog.openConfirm((Shell)DeleteOrganizationAction.getShell(), (String)"Delete Organizational Unit", (String)("Are you sure you want to delete the Organizational Unit " + container.getName() + "?"));
        if (doit) {
            try {
                delegate.deleteOrganization(organization);
                DeleteOrganizationAction.refreshViewer(container.getParent());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

