/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.server.core.IServer;
import org.kie.eclipse.Activator;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.IKieServiceDelegate;

public abstract class KieResourceHandler
implements IKieResourceHandler {
    protected static IEclipsePreferences preferences;
    protected IKieResourceHandler parent;
    protected List children;
    protected String name;
    protected JsonObject properties;

    public KieResourceHandler(IKieResourceHandler parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IKieResourceHandler getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IKieResourceHandler parent) {
        this.parent = parent;
    }

    @Override
    public IKieResourceHandler getRoot() {
        if (this.getParent() == null) {
            return this;
        }
        return this.getParent().getRoot();
    }

    @Override
    public Object getResource() {
        return null;
    }

    @Override
    public void setResource(Object resource) {
    }

    @Override
    public IServer getServer() {
        if (this.parent != null) {
            return this.parent.getServer();
        }
        return null;
    }

    @Override
    public String getRuntimeId() {
        if (this.parent != null) {
            return this.parent.getRuntimeId();
        }
        return null;
    }

    @Override
    public IKieServiceDelegate getDelegate() {
        if (this.parent != null) {
            return this.parent.getDelegate();
        }
        return null;
    }

    @Override
    public void dispose() {
        this.children = null;
    }

    @Override
    public Object load() {
        return null;
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    @Override
    public void setProperties(JsonObject properties) {
        JsonValue v = properties.get("name");
        if (v != null && v.isString()) {
            this.name = v.asString();
        }
        this.properties = properties;
    }

    @Override
    public JsonObject getProperties() {
        return this.properties;
    }

    public static void removeServerPreferences(IServer server) {
        try {
            String name = KieResourceHandler.getCanonicalName(server.getName());
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.kie.eclipse");
            String[] stringArray = preferences.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.startsWith(String.valueOf(name) + "|")) {
                    preferences.remove(key);
                }
                ++n2;
            }
            preferences.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static String getCanonicalName(String name) {
        return name.replaceAll("[^A-Za-z0-9_.,]", "_");
    }

    @Override
    public String getPreferenceName(String name) {
        String canonicalName = KieResourceHandler.getCanonicalName(this.getRoot().getName());
        if (name == null) {
            return canonicalName;
        }
        return String.valueOf(canonicalName) + "|" + KieResourceHandler.getCanonicalName(name);
    }

    public IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    @Override
    public String getPreference(String name, String def) {
        if (this.getPreferenceStore().contains(this.getPreferenceName(name))) {
            return this.getPreferenceStore().getString(this.getPreferenceName(name));
        }
        return def;
    }

    @Override
    public boolean getPreference(String name, boolean def) {
        if (this.getPreferenceStore().contains(this.getPreferenceName(name))) {
            return this.getPreferenceStore().getBoolean(this.getPreferenceName(name));
        }
        return def;
    }

    @Override
    public int getPreference(String name, int def) {
        if (this.getPreferenceStore().contains(this.getPreferenceName(name))) {
            return this.getPreferenceStore().getInt(this.getPreferenceName(name));
        }
        return def;
    }

    @Override
    public void putPreference(String name, String value) {
        this.getPreferenceStore().putValue(this.getPreferenceName(name), value);
    }

    @Override
    public void putPreference(String name, boolean value) {
        this.getPreferenceStore().putValue(this.getPreferenceName(name), Boolean.toString(value));
    }

    @Override
    public void putPreference(String name, int value) {
        this.getPreferenceStore().putValue(this.getPreferenceName(name), Integer.toString(value));
    }
}

