/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.compilers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.drools.compiler.commons.jci.compilers.AbstractJavaCompiler;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.EclipseCompilationProblem;
import org.drools.compiler.commons.jci.compilers.EclipseJavaCompilerSettings;
import org.drools.compiler.commons.jci.compilers.JavaCompilerSettings;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.IoUtils;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.kie.internal.jci.CompilationProblem;

public final class EclipseJavaCompiler
extends AbstractJavaCompiler {
    private String prefix = "";
    private final EclipseJavaCompilerSettings defaultSettings;

    public EclipseJavaCompiler() {
        this(new EclipseJavaCompilerSettings(), "");
    }

    public EclipseJavaCompiler(Map pSettings) {
        this.defaultSettings = new EclipseJavaCompilerSettings(pSettings);
    }

    public EclipseJavaCompiler(EclipseJavaCompilerSettings pSettings, String prefix) {
        this.defaultSettings = pSettings;
        this.prefix = prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPathName(String fullPath) {
        if (this.prefix.length() == 0) {
            return fullPath;
        }
        if (fullPath.charAt(0) == '/') {
            return fullPath.substring(this.prefix.length() + 1);
        }
        return fullPath.substring(this.prefix.length());
    }

    public CompilationResult compile(String[] pSourceFiles, final ResourceReader pReader, final ResourceStore pStore, final ClassLoader pClassLoader, JavaCompilerSettings pSettings) {
        final ArrayList<1> problems = new ArrayList<1>();
        ICompilationUnit[] compilationUnits = new ICompilationUnit[pSourceFiles.length];
        int i = 0;
        while (i < compilationUnits.length) {
            final String sourceFile = pSourceFiles[i];
            if (pReader.isAvailable(sourceFile)) {
                compilationUnits[i] = new CompilationUnit(pReader, sourceFile);
            } else {
                CompilationProblem problem = new CompilationProblem(){

                    public int getEndColumn() {
                        return 0;
                    }

                    public int getEndLine() {
                        return 0;
                    }

                    public String getFileName() {
                        return sourceFile;
                    }

                    public String getMessage() {
                        return "Source " + sourceFile + " could not be found";
                    }

                    public int getStartColumn() {
                        return 0;
                    }

                    public int getStartLine() {
                        return 0;
                    }

                    public boolean isError() {
                        return true;
                    }

                    public String toString() {
                        return this.getMessage();
                    }
                };
                if (this.problemHandler != null) {
                    this.problemHandler.handle(problem);
                }
                problems.add(problem);
            }
            ++i;
        }
        if (problems.size() > 0) {
            CompilationProblem[] result = new CompilationProblem[problems.size()];
            problems.toArray(result);
            return new CompilationResult(result);
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        INameEnvironment nameEnvironment = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] pCompoundTypeName) {
                StringBuilder result = new StringBuilder();
                int i = 0;
                while (i < pCompoundTypeName.length) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(pCompoundTypeName[i]);
                    ++i;
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] pTypeName, char[][] pPackageName) {
                StringBuilder result = new StringBuilder();
                int i = 0;
                while (i < pPackageName.length) {
                    result.append(pPackageName[i]);
                    result.append('.');
                    ++i;
                }
                result.append(pTypeName);
                return this.findType(result.toString());
            }

            /*
             * Unable to fully structure code
             */
            private NameEnvironmentAnswer findType(String pClazzName) {
                resourceName = ClassUtils.convertClassToResourcePath((String)pClazzName);
                clazzBytes = pStore.read(resourceName);
                if (clazzBytes != null) {
                    try {
                        return this.createNameEnvironmentAnswer(pClazzName, clazzBytes);
                    }
                    catch (ClassFormatException v0) {
                        throw new RuntimeException("ClassFormatException in loading class '" + pClazzName + "' with JCI.");
                    }
                }
                is = null;
                baos = null;
                try {
                    is = pClassLoader.getResourceAsStream(resourceName);
                    if (is == null) {
                        return null;
                    }
                    if (ClassUtils.isWindows() || ClassUtils.isOSX()) {
                        try {
                            pClassLoader.loadClass(pClazzName);
                        }
                        catch (ClassNotFoundException v1) {
                            try {
                                if (baos != null) {
                                    baos.close();
                                }
                            }
                            catch (IOException oe) {
                                throw new RuntimeException("could not close output stream", oe);
                            }
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException ie) {
                                throw new RuntimeException("could not close input stream", ie);
                            }
                            return null;
                        }
                        catch (NoClassDefFoundError v2) {
                            ** try [egrp 8[TRYBLOCK] [13, 17, 21 : 215->216)] { 
lbl35:
                            // 1 sources

                            try {
                                if (baos != null) {
                                    baos.close();
                                }
                            }
                            catch (IOException oe) {
                                throw new RuntimeException("could not close output stream", oe);
                            }
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException ie) {
                                throw new RuntimeException("could not close input stream", ie);
                            }
                            return null;
                        }
                    }
                    buffer = new byte[8192];
                    baos = new ByteArrayOutputStream(buffer.length);
                    while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                        baos.write(buffer, 0, count);
                    }
                    baos.flush();
                    var9_20 = this.createNameEnvironmentAnswer(pClazzName, baos.toByteArray());
                    return var9_20;
lbl-1000:
                    // 2 sources

                    {
                        catch (IOException e) {
                            throw new RuntimeException("could not read class", e);
                        }
lbl58:
                        // 2 sources

                        catch (ClassFormatException e) {
                            throw new RuntimeException("wrong class format", e);
                        }
lbl60:
                        // 1 sources

                        catch (Throwable var8_21) {
                            throw var8_21;
                        }
                    }
                }
                finally {
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (IOException oe) {
                        throw new RuntimeException("could not close output stream", oe);
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ie) {
                        throw new RuntimeException("could not close input stream", ie);
                    }
                }
            }

            private NameEnvironmentAnswer createNameEnvironmentAnswer(String pClazzName, byte[] clazzBytes) throws ClassFormatException {
                char[] fileName = pClazzName.toCharArray();
                ClassFileReader classFileReader = new ClassFileReader(clazzBytes, fileName, true);
                return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
            }

            private boolean isSourceAvailable(String pClazzName, ResourceReader pReader2) {
                String javaSource = String.valueOf(pClazzName.replace('.', '/')) + ".java";
                String classSource = String.valueOf(pClazzName.replace('.', '/')) + ".class";
                return pReader2.isAvailable(String.valueOf(EclipseJavaCompiler.this.prefix) + javaSource) || pReader2.isAvailable(String.valueOf(EclipseJavaCompiler.this.prefix) + classSource);
            }

            /*
             * Exception decompiling
             */
            private boolean isPackage(String pClazzName) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public boolean isPackage(char[][] parentPackageName, char[] pPackageName) {
                StringBuilder result = new StringBuilder();
                if (parentPackageName != null) {
                    int i = 0;
                    while (i < parentPackageName.length) {
                        if (i != 0) {
                            result.append('.');
                        }
                        result.append(parentPackageName[i]);
                        ++i;
                    }
                }
                if (parentPackageName != null && parentPackageName.length > 0) {
                    result.append('.');
                }
                result.append(pPackageName);
                return this.isPackage(result.toString());
            }

            public void cleanup() {
            }
        };
        ICompilerRequestor compilerRequestor = new ICompilerRequestor(){

            public void acceptResult(org.eclipse.jdt.internal.compiler.CompilationResult pResult) {
                int i;
                if (pResult.hasProblems()) {
                    CategorizedProblem[] iproblems = pResult.getProblems();
                    i = 0;
                    while (i < iproblems.length) {
                        CategorizedProblem iproblem = iproblems[i];
                        EclipseCompilationProblem problem = new EclipseCompilationProblem((IProblem)iproblem);
                        if (EclipseJavaCompiler.this.problemHandler != null) {
                            EclipseJavaCompiler.this.problemHandler.handle((CompilationProblem)problem);
                        }
                        problems.add(problem);
                        ++i;
                    }
                }
                if (!pResult.hasErrors()) {
                    ClassFile[] clazzFiles = pResult.getClassFiles();
                    i = 0;
                    while (i < clazzFiles.length) {
                        ClassFile clazzFile = clazzFiles[i];
                        char[][] compoundName = clazzFile.getCompoundName();
                        StringBuilder clazzName = new StringBuilder();
                        int j = 0;
                        while (j < compoundName.length) {
                            if (j != 0) {
                                clazzName.append('.');
                            }
                            clazzName.append(compoundName[j]);
                            ++j;
                        }
                        pStore.write(String.valueOf(clazzName.toString().replace('.', '/')) + ".class", clazzFile.getBytes());
                        ++i;
                    }
                }
            }
        };
        Map settingsMap = new EclipseJavaCompilerSettings(pSettings).toNativeSettings();
        CompilerOptions compilerOptions = new CompilerOptions(settingsMap);
        compilerOptions.parseLiteralExpressionsAsConstants = false;
        Compiler compiler = new Compiler(nameEnvironment, policy, compilerOptions, compilerRequestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        CompilationProblem[] result = new CompilationProblem[problems.size()];
        problems.toArray(result);
        return new CompilationResult(result);
    }

    public JavaCompilerSettings createDefaultSettings() {
        return this.defaultSettings;
    }

    final class CompilationUnit
    implements ICompilationUnit {
        private final String clazzName;
        private final String fileName;
        private final char[] typeName;
        private final char[][] packageName;
        private final ResourceReader reader;

        CompilationUnit(ResourceReader pReader, String pSourceFile) {
            this.reader = pReader;
            this.clazzName = ClassUtils.convertResourceToClassName((String)EclipseJavaCompiler.this.getPathName(pSourceFile));
            this.fileName = pSourceFile;
            int dot = this.clazzName.lastIndexOf(46);
            this.typeName = dot > 0 ? this.clazzName.substring(dot + 1).toCharArray() : this.clazzName.toCharArray();
            StringTokenizer izer = new StringTokenizer(this.clazzName, ".");
            this.packageName = new char[izer.countTokens() - 1][];
            int i = 0;
            while (i < this.packageName.length) {
                this.packageName[i] = izer.nextToken().toCharArray();
                ++i;
            }
        }

        public char[] getFileName() {
            return this.fileName.toCharArray();
        }

        public char[] getContents() {
            byte[] content = this.reader.getBytes(this.fileName);
            if (content == null) {
                return null;
            }
            return new String(content, IoUtils.UTF8_CHARSET).toCharArray();
        }

        public char[] getMainTypeName() {
            return this.typeName;
        }

        public char[][] getPackageName() {
            return this.packageName;
        }

        public boolean ignoreOptionalProblems() {
            return true;
        }
    }
}

