/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.core.ui;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.core.ui.DroolsFilter;
import org.drools.eclipse.core.ui.FilterAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class FilterActionGroup
extends ActionGroup {
    private FilterAction[] filterActions;
    private DroolsFilter filter;
    public int i;
    private StructuredViewer viewer;
    private String viewerId;

    public FilterActionGroup(StructuredViewer viewer, String viewerId) {
        this.viewer = viewer;
        this.viewerId = viewerId;
        this.filter = new DroolsFilter();
        this.filterActions = new FilterAction[]{this.addFilterForType(1, "Hide Rules", "DroolsRule"), this.addFilterForType(2, "Hide Queries", "DroolsQuery"), this.addFilterForType(4, "Hide Functions", "Method"), this.addFilterForType(16, "Hide Globals", "Global"), this.addFilterForType(8, "Hide Templates", "Class"), this.addFilterForType(32, "Hide Agenda/RuleFlow Groups", "RuleFlowGroup")};
        viewer.addFilter((ViewerFilter)this.filter);
    }

    private FilterAction addFilterForType(int filterType, String tooltip, String imageDescriptorKey) {
        boolean filterEnabled = DroolsEclipsePlugin.getDefault().getPreferenceStore().getBoolean(this.getPreferenceKey(filterType));
        if (filterEnabled) {
            this.filter.addFilter(filterType);
        }
        FilterAction hideAction = new FilterAction(this, tooltip, filterType, filterEnabled, imageDescriptorKey);
        hideAction.setToolTipText(tooltip);
        return hideAction;
    }

    private String getPreferenceKey(int filterProperty) {
        return "DroolsFilterActionGroup." + this.viewerId + '.' + String.valueOf(filterProperty);
    }

    public void setFilter(int filterType, boolean set) {
        this.setDroolsFilters(new int[]{filterType}, new boolean[]{set}, true);
    }

    private void setDroolsFilters(int[] propertyKeys, boolean[] propertyValues, boolean refresh) {
        if (propertyKeys.length == 0) {
            return;
        }
        Assert.isTrue((propertyKeys.length == propertyValues.length ? 1 : 0) != 0);
        int i = 0;
        while (i < propertyKeys.length) {
            int filterProperty = propertyKeys[i];
            boolean set = propertyValues[i];
            IPreferenceStore store = DroolsEclipsePlugin.getDefault().getPreferenceStore();
            boolean found = false;
            int j = 0;
            while (j < this.filterActions.length) {
                int currProperty = this.filterActions[j].getFilterType();
                if (currProperty == filterProperty) {
                    this.filterActions[j].setChecked(set);
                    found = true;
                    store.setValue(this.getPreferenceKey(filterProperty), set);
                }
                ++j;
            }
            if (found) {
                if (set) {
                    this.filter.addFilter(filterProperty);
                } else {
                    this.filter.removeFilter(filterProperty);
                }
            }
            ++i;
        }
        if (refresh) {
            this.viewer.getControl().setRedraw(false);
            BusyIndicator.showWhile((Display)this.viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    FilterActionGroup.this.viewer.refresh();
                }
            });
            this.viewer.getControl().setRedraw(true);
        }
    }

    public boolean hasDroolsFilter(int filterType) {
        return this.filter.hasFilter(filterType);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.contributeToToolBar(actionBars.getToolBarManager());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        int i = 0;
        while (i < this.filterActions.length) {
            tbm.add((IAction)this.filterActions[i]);
            ++i;
        }
    }
}

