/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.preferences.IGuvnorPreferenceConstants;
import org.guvnor.tools.utils.PlatformUtils;

public class GuvnorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text guvnorURLTemplate;
    private Button savePassword;
    private Combo decorationIconLoc;
    private Button incChangeIndicator;
    private Button incRevision;
    private Button incDateStamp;

    public GuvnorPreferencePage() {
    }

    public GuvnorPreferencePage(String title) {
        super(title);
    }

    public GuvnorPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite composite = PlatformUtils.createComposite(parent, 1);
        Group group = new Group(composite, 0);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setText(Messages.getString("prepage.repository.connections"));
        Composite doubleLine = PlatformUtils.createComposite((Composite)group, 2);
        new Label(doubleLine, 0).setText(Messages.getString("prepage.guvnor.url.template"));
        this.guvnorURLTemplate = new Text(doubleLine, 2048);
        this.guvnorURLTemplate.setLayoutData((Object)new GridData(768));
        this.guvnorURLTemplate.setText(GuvnorPreferencePage.getGuvnorTemplatePref());
        this.savePassword = new Button((Composite)group, 32);
        this.savePassword.setText(Messages.getString("prepage.save.passwords"));
        this.savePassword.setLayoutData((Object)new GridData(768));
        this.savePassword.setSelection(true);
        group = new Group(composite, 0);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setText(Messages.getString("prepage.file.decoration"));
        doubleLine = PlatformUtils.createComposite((Composite)group, 2);
        new Label(doubleLine, 0).setText(Messages.getString("prepage.decoration.location"));
        this.decorationIconLoc = new Combo(doubleLine, 2052);
        String[] locs = IGuvnorPreferenceConstants.OVERLAY_LOCATIONS;
        int i = 0;
        while (i < locs.length) {
            this.decorationIconLoc.add(locs[i]);
            ++i;
        }
        this.decorationIconLoc.select(GuvnorPreferencePage.getOverlayLocationPref());
        Group textDec = new Group((Composite)group, 0);
        data = new GridData(768);
        textDec.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        textDec.setLayout((Layout)layout);
        textDec.setText(Messages.getString("prepage.decoration.text"));
        this.incChangeIndicator = new Button((Composite)textDec, 32);
        this.incChangeIndicator.setText(Messages.getString("prepage.include.change.indicator"));
        this.incChangeIndicator.setLayoutData((Object)new GridData(768));
        this.incChangeIndicator.setSelection(GuvnorPreferencePage.shouldShowChangeIndicator());
        this.incRevision = new Button((Composite)textDec, 32);
        this.incRevision.setText(Messages.getString("prepage.include.revision"));
        this.incRevision.setLayoutData((Object)new GridData(768));
        this.incRevision.setSelection(GuvnorPreferencePage.shouldShowRevision());
        this.incDateStamp = new Button((Composite)textDec, 32);
        this.incDateStamp.setText(Messages.getString("prepage.include.date.time.stamp"));
        this.incDateStamp.setLayoutData((Object)new GridData(768));
        this.incDateStamp.setSelection(GuvnorPreferencePage.shouldShowTimeDateStamp());
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String defaultLoc = store.getDefaultString("guvnor_loc_template");
        if (defaultLoc == null || "".equals(defaultLoc)) {
            defaultLoc = "http://localhost:8080/drools-guvnor/org.drools.guvnor.Guvnor/webdav/";
        }
        store.putValue("guvnor_loc_template", defaultLoc);
        this.guvnorURLTemplate.setText(defaultLoc);
        store.putValue("save_passwords", String.valueOf(true));
        this.savePassword.setSelection(true);
        store.putValue("overlay_location", String.valueOf(1));
        this.decorationIconLoc.select(1);
        store.putValue("show_change_indicator", String.valueOf(true));
        this.incChangeIndicator.setSelection(true);
        store.putValue("show_revision", String.valueOf(true));
        this.incRevision.setSelection(true);
        store.putValue("show_datetime", String.valueOf(true));
        this.incDateStamp.setSelection(true);
        PlatformUtils.updateDecoration();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.putValue("guvnor_loc_template", this.guvnorURLTemplate.getText());
        store.putValue("save_passwords", String.valueOf(this.savePassword.getSelection()));
        store.putValue("overlay_location", String.valueOf(this.decorationIconLoc.getSelectionIndex()));
        store.putValue("show_change_indicator", String.valueOf(this.incChangeIndicator.getSelection()));
        store.putValue("show_revision", String.valueOf(this.incRevision.getSelection()));
        store.putValue("show_datetime", String.valueOf(this.incDateStamp.getSelection()));
        PlatformUtils.updateDecoration();
        return super.performOk();
    }

    public static String getGuvnorTemplatePref() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String res = null;
        if (!store.contains("guvnor_loc_template")) {
            res = "http://localhost:8080/drools-guvnor/org.drools.guvnor.Guvnor/webdav/";
            store.putValue("guvnor_loc_template", res);
        } else {
            res = store.getString("guvnor_loc_template");
        }
        return res;
    }

    public static boolean shouldSavePasswords() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean res = true;
        if (!store.contains("save_passwords")) {
            store.putValue("save_passwords", String.valueOf(true));
        } else {
            res = store.getBoolean("save_passwords");
        }
        return res;
    }

    public static int getOverlayLocationPref() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int res = 0;
        if (!store.contains("overlay_location")) {
            store.putValue("overlay_location", String.valueOf(1));
            res = 1;
        } else {
            res = store.getInt("overlay_location");
        }
        return res;
    }

    public static boolean shouldShowChangeIndicator() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean res = true;
        if (!store.contains("show_change_indicator")) {
            store.putValue("show_change_indicator", String.valueOf(true));
        } else {
            res = store.getBoolean("show_change_indicator");
        }
        return res;
    }

    public static boolean shouldShowRevision() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean res = true;
        if (!store.contains("show_revision")) {
            store.putValue("show_revision", String.valueOf(true));
        } else {
            res = store.getBoolean("show_revision");
        }
        return res;
    }

    public static boolean shouldShowTimeDateStamp() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean res = true;
        if (!store.contains("show_datetime")) {
            store.putValue("show_datetime", String.valueOf(true));
        } else {
            res = store.getBoolean("show_datetime");
        }
        return res;
    }
}

