/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.preferences.GuvnorPreferencePage;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.IGuvnorWizard;

public class GuvnorMainConfigPage
extends WizardPage {
    private Text serverField;
    private Text portField;
    private Text replocField;
    private Text unField;
    private Text pwField;
    private Button cbSavePassword;
    private boolean saveAuthInfo;
    private Label warningLabel;
    private boolean initialized = false;

    public GuvnorMainConfigPage(String pageName) {
        super(pageName);
    }

    public GuvnorMainConfigPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        boolean shouldSavePasswords;
        Composite composite = PlatformUtils.createComposite(parent, 2);
        new Label(composite, 0).setText(Messages.getString("mainconfig.guvnor.loc"));
        this.serverField = new Text(composite, 2052);
        this.serverField.setLayoutData((Object)new GridData(768));
        this.serverField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        this.addDropSupport(this.serverField);
        this.serverField.setFocus();
        new Label(composite, 0).setText(Messages.getString("mainconfig.port"));
        this.portField = new Text(composite, 2052);
        this.portField.setLayoutData((Object)new GridData(768));
        this.portField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        new Label(composite, 0).setText(Messages.getString("mainconfig.rep"));
        this.replocField = new Text(composite, 2052);
        this.replocField.setLayoutData((Object)new GridData(768));
        this.replocField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        new Label(composite, 0).setText(Messages.getString("mainconfig.user.name"));
        this.unField = new Text(composite, 2052);
        this.unField.setLayoutData((Object)new GridData(768));
        this.unField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        new Label(composite, 0).setText(Messages.getString("mainconfig.password"));
        this.pwField = new Text(composite, 0x400804);
        this.pwField.setLayoutData((Object)new GridData(768));
        this.pwField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        new Label(composite, 0).setLayoutData((Object)new GridData(768));
        Composite pwgroup = PlatformUtils.createComposite(composite, 2);
        this.cbSavePassword = new Button(pwgroup, 32);
        this.cbSavePassword.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GuvnorMainConfigPage.this.saveAuthInfo = GuvnorMainConfigPage.this.cbSavePassword.getSelection();
                GuvnorMainConfigPage.this.warningLabel.setEnabled(GuvnorMainConfigPage.this.saveAuthInfo);
                GuvnorMainConfigPage.this.updateModel();
            }
        });
        this.saveAuthInfo = shouldSavePasswords = this.shouldSavePasswords();
        this.cbSavePassword.setSelection(shouldSavePasswords);
        new Label(pwgroup, 0).setText(Messages.getString("mainconfig.save.password"));
        new Label(composite, 0).setLayoutData((Object)new GridData(768));
        this.warningLabel = new Label(composite, 64);
        this.warningLabel.setText(Messages.getString("password.warning"));
        this.warningLabel.setEnabled(shouldSavePasswords);
        super.setControl((Control)composite);
    }

    private void addDropSupport(Text field) {
        int operations = 17;
        DropTarget target = new DropTarget((Control)field, operations);
        final TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                if (textTransfer.isSupportedType(event.currentDataType)) {
                    GuvnorMainConfigPage.this.parseCandidateUrl((String)event.data);
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    private void parseCandidateUrl(String dropped) {
        try {
            URL server = new URL(dropped);
            this.serverField.setText(server.getHost());
            if (server.getPort() != -1) {
                this.portField.setText(String.valueOf(server.getPort()));
            }
            this.replocField.setText(server.getFile());
        }
        catch (MalformedURLException e) {
            Activator.getDefault().writeLog(4, e.getMessage(), e);
        }
    }

    private void updateModel() {
        GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
        try {
            URL server = this.validateUrl();
            model.setRepLocation(server.toString());
            model.setUsername(this.unField.getText());
            model.setPassword(this.pwField.getText());
            model.setSaveAuthInfo(this.saveAuthInfo);
            model.setCreateNewRep(true);
        }
        catch (Exception exception) {
            model.setRepLocation(null);
        }
        IWizardContainer container = super.getWizard().getContainer();
        if (container != null) {
            container.updateButtons();
        }
    }

    private URL validateUrl() throws Exception {
        if (this.serverField.getText().trim().length() == 0) {
            return null;
        }
        URL res = this.testCompleteField();
        if (res != null) {
            return res;
        }
        String repPath = null;
        repPath = this.replocField.getText().trim().length() > 0 ? (this.replocField.getText().startsWith("/") ? this.replocField.getText() : "/" + this.replocField.getText()) : "";
        if (this.portField.getText().trim().length() > 0) {
            int port = Integer.parseInt(this.portField.getText());
            res = new URL("http", this.serverField.getText(), port, repPath);
        } else {
            res = new URL("http", this.serverField.getText(), repPath);
        }
        return res;
    }

    private URL testCompleteField() {
        URL res = null;
        try {
            res = new URL(this.serverField.getText());
            this.parseCandidateUrl(res.toString());
        }
        catch (MalformedURLException malformedURLException) {}
        return res;
    }

    public boolean isPageComplete() {
        GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
        return model.getRepLocation() != null;
    }

    public void setVisible(boolean visible) {
        if (visible && !this.initialized) {
            String guvnorLocTemplate = this.getGuvnorLocation();
            if (guvnorLocTemplate != null && guvnorLocTemplate.trim().length() > 0) {
                this.parseCandidateUrl(guvnorLocTemplate);
            }
            this.initialized = true;
            this.initializeUserInfo(this.getSecurityInfo());
        }
        super.setVisible(visible);
    }

    protected String getGuvnorLocation() {
        return GuvnorPreferencePage.getGuvnorTemplatePref();
    }

    protected Map getSecurityInfo() {
        return null;
    }

    protected boolean shouldSavePasswords() {
        return GuvnorPreferencePage.shouldSavePasswords();
    }

    private void initializeUserInfo(Map info) {
        String pw;
        if (info == null) {
            return;
        }
        String un = (String)info.get("username");
        if (un != null) {
            this.unField.setText(un);
        }
        if ((pw = (String)info.get("password")) != null) {
            this.pwField.setText(pw);
        }
    }
}

