/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jbpm.eclipse.JBPMEclipsePlugin;
import org.jbpm.eclipse.util.JBPMRuntimeManager;

public class JBPMClasspathContainer
implements IClasspathContainer {
    public static final IPath JBPM_CLASSPATH_CONTAINER_PATH = new Path("JBPM/jbpm");
    IClasspathEntry[] jbpmLibraryEntries;
    IPath path;
    IJavaProject javaProject = null;

    public JBPMClasspathContainer(IJavaProject project) {
        this(project, JBPM_CLASSPATH_CONTAINER_PATH);
    }

    public JBPMClasspathContainer(IJavaProject project, IPath path) {
        this.javaProject = project;
        this.path = path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasJBPMClassPath(IJavaProject project) {
        try {
            IClasspathEntry[] classpathEntries = project.getRawClasspath();
            int i = 0;
            while (true) {
                if (i >= classpathEntries.length) {
                    return false;
                }
                if (JBPM_CLASSPATH_CONTAINER_PATH.equals((Object)classpathEntries[i].getPath().toString())) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JBPMEclipsePlugin.log(e);
        }
        return false;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.jbpmLibraryEntries == null) {
            this.jbpmLibraryEntries = this.createJBPMLibraryEntries(this.javaProject);
        }
        return this.jbpmLibraryEntries;
    }

    public String getDescription() {
        return "jBPM Library";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    private IClasspathEntry[] createJBPMLibraryEntries(IJavaProject project) {
        String[] jarNames = this.getJarNames(project);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        if (jarNames != null) {
            int i = 0;
            while (i < jarNames.length) {
                Path path = new Path(jarNames[i]);
                list.add(JavaCore.newLibraryEntry((IPath)path, (IPath)path, null));
                ++i;
            }
        }
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    private String[] getJarNames(IJavaProject project) {
        return JBPMRuntimeManager.getDefault().getRuntimeJars(project.getProject());
    }
}

