/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public final class URLDecoder {
    private static final byte[] hexChars = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 65, 66, 67, 68, 69, 70};
    private static final byte[] hexCharValues;

    static {
        byte[] byArray = new byte[22];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 10;
        byArray[17] = 11;
        byArray[18] = 12;
        byArray[19] = 13;
        byArray[20] = 14;
        byArray[21] = 15;
        hexCharValues = byArray;
    }

    private URLDecoder() {
    }

    public static String decode(String url) {
        try {
            return URLDecoder.decode(new URL(url)).toString();
        }
        catch (MalformedURLException malformedURLException) {
            String file;
            String ref = null;
            int lastSlashIndex = url.lastIndexOf(47);
            int lastHashIndex = url.lastIndexOf(35);
            if (lastHashIndex - lastSlashIndex > 1 && lastHashIndex < url.length() - 1) {
                file = url.substring(0, lastHashIndex);
                ref = url.substring(lastHashIndex + 1, url.length());
            } else {
                file = url;
            }
            return URLDecoder.decode(file, ref);
        }
    }

    public static String decode(String file, String ref) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(file, "/", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("/")) {
                buf.append(token);
                continue;
            }
            buf.append(URLDecoder.decodeSegment(token));
        }
        if (ref != null) {
            buf.append('#');
            buf.append(URLDecoder.decodeSegment(ref));
        }
        return buf.toString();
    }

    public static URL decode(URL url) {
        String file = url.getFile();
        String ref = url.getRef();
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), URLDecoder.decode(file, ref));
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public static String decodeSegment(String segment) {
        byte[] encodedBytes = segment.getBytes();
        byte[] decodedBytes = new byte[encodedBytes.length];
        int decodedLength = 0;
        int i = 0;
        while (i < encodedBytes.length) {
            byte b = encodedBytes[i];
            try {
                if (b == 37) {
                    byte enc1 = encodedBytes[++i];
                    byte enc2 = encodedBytes[++i];
                    b = (byte)((URLDecoder.hexToByte(enc1) << 4) + URLDecoder.hexToByte(enc2));
                }
                decodedBytes[decodedLength++] = b;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Assert.isTrue(false, Policy.bind("assert.decodeSegment"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.isTrue(false, Policy.bind("assert.decodeSegment"));
            }
            ++i;
        }
        try {
            return new String(decodedBytes, 0, decodedLength, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    private static final byte hexToByte(byte ch) {
        int i = 0;
        while (i < hexChars.length) {
            if (hexChars[i] == ch) {
                return hexCharValues[i];
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }
}

