/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.IGuvnorWizard;

public class SelectLocalTargetPage
extends WizardPage {
    private TreeViewer viewer;

    public SelectLocalTargetPage(String pageName) {
        super(pageName);
    }

    public SelectLocalTargetPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = PlatformUtils.createComposite(parent, 1);
        new Label(composite, 0).setText(Messages.getString("select.location"));
        this.viewer = new TreeViewer(composite, 2820);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        this.viewer.setContentProvider((IContentProvider)cp);
        this.viewer.setFilters(new ViewerFilter[]{new ProjectFilter()});
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectLocalTargetPage.this.updateModel();
            }
        });
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        super.setControl((Control)composite);
    }

    private void updateModel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof IContainer) {
            IContainer container = (IContainer)selection.getFirstElement();
            GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
            model.setTargetLocation(container.getFullPath().toString());
            super.getWizard().getContainer().updateButtons();
        }
    }

    class ProjectFilter
    extends ViewerFilter {
        ProjectFilter() {
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            return element instanceof IContainer;
        }
    }
}

