/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public final class URLEncoder {
    private URLEncoder() {
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(new URL(url)).toString();
        }
        catch (MalformedURLException malformedURLException) {
            String file;
            String ref = null;
            int lastSlashIndex = url.lastIndexOf(47);
            int lastHashIndex = url.lastIndexOf(35);
            if (lastHashIndex - lastSlashIndex > 1 && lastHashIndex < url.length() - 1) {
                file = url.substring(0, lastHashIndex);
                ref = url.substring(lastHashIndex + 1, url.length());
            } else {
                file = url;
            }
            return URLEncoder.encode(file, ref);
        }
    }

    public static String encode(String file, String ref) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(file, "/", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("/")) {
                buf.append(token);
                continue;
            }
            buf.append(URLEncoder.encodeSegment(token));
        }
        if (ref != null) {
            buf.append('#');
            buf.append(URLEncoder.encodeSegment(ref));
        }
        return buf.toString();
    }

    public static URL encode(URL url) {
        String file = url.getFile();
        String ref = url.getRef();
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), URLEncoder.encode(file, ref));
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    private static String encodeSegment(String segment) {
        StringBuffer result = new StringBuffer(segment.length());
        int i = 0;
        while (i < segment.length()) {
            char c = segment.charAt(i);
            if (URLEncoder.mustEncode(c)) {
                byte[] bytes = null;
                try {
                    bytes = new Character(c).toString().getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                int j = 0;
                while (j < bytes.length) {
                    result.append('%');
                    result.append(Integer.toHexString(bytes[j] >> 4 & 0xF));
                    result.append(Integer.toHexString(bytes[j] & 0xF));
                    ++j;
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private static boolean mustEncode(char c) {
        if (c >= 'a' && c <= 'z') {
            return false;
        }
        if (c >= 'A' && c <= 'Z') {
            return false;
        }
        if (c >= '0' && c <= '9') {
            return false;
        }
        if (c >= '\'' && c <= '.') {
            return false;
        }
        return c != '!' && c != '$' && c != '_';
    }
}

